<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<!-- advice from http://stackoverflow.com/questions/22268374/changing-the-width-of-twitter-bootstrap-popover -->
	<style type="text/css" class="init">

	th.wrappings, td.wrappings { white-space: nowrap; }
	div.dataTables_wrapper {
		width: 1400px;
		margin: 0 auto;
	}
	
	
	.popover
	{
    	width:auto;
    	max-width: none;
    	height:auto;    
	}

	</style>
	<script>
		function showHint(s, t, a, g, auto) {
			if (s.length == 0) {
				document.getElementById("txtHint").innerHTML = "";
				return;
			} else {
				var xmlhttp = new XMLHttpRequest();
				xmlhttp.onreadystatechange = function() {
					if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
						document.getElementById("txtHint").innerHTML = xmlhttp.responseText;
					}
				}
				xmlhttp.open("GET", "splicing_magnify.php?size=" + s + '&transcript_id=' + t + '&alignment_key=' + a + '&species=' + g + '&auto=' + auto, true);
				xmlhttp.send();
			}
		}
	</script>
	<script src="js/jquery.js"></script>
	<script src="js/bootstrap.min.js"></script>
</head>



<body>

    <!-- Navigation -->
    <?php include("nav.php"); ?>
	<!-- End of Navigation -->

    <!-- Page Content -->
    <div class='container'>
    	<div class="row">
			<?php 
		
				include("DatabaseConnect.php");
				
				$mainQueryLink = $_POST['mainQueryLink'];
				
				////////////////////////////////////////////////////////////////////////////////
				// get alignment id

				$alignment_key = $_GET['id'];
				$species = $_GET['species'];
				$database1 = 'alignment_ids';

				$species_array = array('amborella' => 'Amborella_trichopoda', 'arabidopsis' => 'Arabidopsis_thaliana', 'chlamydomonas' => 'Chlamydomonas_reinhardtii', 'glycine' => 'Glycine_max', 'physcomitrella' => 'Physcomitrella_patens', 'potato' => 'Solanum_tuberosum', 'selaginella' => 'Selaginella_moellendorffii', 'vitis' => 'Vitis_vinifera', 'zea' => 'Zea mays', 'oryza' => 'Oryza_sativa');
				$species_list_full = array('arabidopsis' => 'Arabidopsis thaliana', 'amborella' => 'Amborella trichopoda', 'glycine' => 'Glycine max', 'oryza' => 'Oryza sativa', 'zea' => 'Zea mays', 'vitis' => 'Vitis vinifera', 'potato' => 'Solanum tuberosum', 'selaginella' => 'Selaginella moellendorffii', 'physcomitrella' => 'Physcomitrella patens', 'chlamydomonas' => 'Chlamydomonas reinhardtii');

				$data = explode('*', $alignment_key);
				$transcript_name = $data[0];
				$id = $data[1];
				$lncrna = $data[1];
				$lncrna_name = generate_id($lncrna);
				
				$codedMainQueryLink = str_replace('=', '*', $mainQueryLink);
				$codedMainQueryLink = str_replace('&', '(', $codedMainQueryLink);
				$codedMainQueryLink = str_replace('search.php?', 'FrOnTuRl', $codedMainQueryLink);
				
				print "
					<div class='btn-group' role='group' aria-label='...'>
						<a class='btn btn-default' href='$mainQueryLink'>&laquo; Back to <b><i>$species_list_full[$species]</i></b> search</a>
						<a class='btn btn-default' href='details.php?id=$lncrna&species=$species&mainQueryLink=$codedMainQueryLink'>&laquo; Back to <b>$lncrna_name</b> details page</a>
					</div>";


				$lncrna_start = $data[2];
				$transcript_start = $data[4];

				$query_id = "select * from $database1 where id = '$alignment_key';";


				if (!($result_id = @ mysql_query($query_id)))
					die ("Could not execute mySQL query: id :)");

	


					$alignment_id = mysql_result($result_id,0,"alignment_id"); 
	
	
					$alignment_key2 = explode('*', $alignment_key);
					$transcript_id = $alignment_key2[0];
		
	


	
				////////////////////////////////////////////////////////////////////////////////
				////////////////////////////////////////////////////////////////////////////////
				////////////////////////////////////////////////////////////////////////////////
	
				$database2 = 'alignments';
				$query = "select * from $database2 where alignment_id = '$alignment_id';";
				////////////////////////////////////////////////////////////////////////////////
				////////////////////////////////////////////////////////////////////////////////
				////////////////////////////////////////////////////////////////////////////////


				if (!($result = @ mysql_query($query)))
					die ("Could not execute mySQL query");

	


					$lncrna_sequence = mysql_result($result,0,"lncrna_sequence");  
					$bars = mysql_result($result,0,"bars");  
					$transcript_sequence = mysql_result($result,0,"transcript_sequence");  
	
	
					$length = 70;
					
	
					$lower_flag = 0;
					$upper_flag = 0;
					$prev_lower_flag = 0;
					$prev_upper_flag = 0;
	
					print "<br/><br/><h4>lncRNA-RNA alignment</h4><hr/>";
					print "<pre style='border:none; background:none'  id='aln'>";
					print "<span style = 'background-color: #99FF99; padding: 2px; border: 1px solid grey;'>ATGC</span> Exon";
					print "<span style = 'padding-left: 20px;'></span><span style = 'background-color: #FFFFCC; padding: 2px; border: 1px solid grey;'>atgc</span> Intron";
	
					print "<br/><br/>";
	
					for($k = 0; $k < ceil(strlen($lncrna_sequence)/$length); $k++)
						{
						$start = $k * $length;
						$end = ($k+1) * $length;
						if($end > strlen($lncrna_sequence))
							{
							$end = strlen($lncrna_sequence);
							}
						$len = $end - $start;
						$lncrna_part = substr($lncrna_sequence, $start, $len);
						$bars_part = substr($bars, $start, $len);
						$transcript_part = substr($transcript_sequence, $start, $len);
		
						$transcript_part_color = '<span>';
						$lncrna_part_color = '<span>';
						$bars_part_color = '<span>';
						for ($n = 0; $n < strlen($transcript_part); $n++)
							{
							$transcript_nt = $transcript_part[$n];
							$bars_nt = $bars_part[$n];
							$lncrna_nt = $lncrna_part[$n];
			
							if(ctype_lower($transcript_nt))
							  {
							  $lower_flag = 1;
							  }
							else
							  {
							  $lower_flag = 0;
							  }
							if (($lower_flag && $prev_lower_flag == 0 && $transcript_nt != '-') || ($n ==0 && $lower_flag))
								{
								$transcript_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
								$bars_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
								$lncrna_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
								}
							if (($lower_flag == 0 && $prev_lower_flag == 1 && $transcript_nt != '-') || ($n ==0 && $lower_flag == 0))
								{
								$transcript_part_color .= "</span><span style = 'background-color: #99FF99;'>";
								$bars_part_color .= "</span><span style = 'background-color: #99FF99;'>";
								$lncrna_part_color .= "</span><span style = 'background-color: #99FF99;'>";
								}
							$transcript_part_color .= $transcript_part[$n];
							$bars_part_color .= $bars_part[$n];
							$lncrna_part_color .= $lncrna_part[$n];
			
							$prev_lower_flag = $lower_flag;
							}
						$transcript_part_color .= '</span>';
						$bars_part_color .= '</span>';
						$lncrna_part_color .= '</span>';
						$species_full = $species_array[$species];
						$ensembl_link = "http://plants.ensembl.org/" . $species_full . "/Gene/Summary?;t=" . $transcript_name;
						$cantata_link = "details.php?id=" . $id;
						$lncrna_coord = $k * $length + $lncrna_start;
						$transcript_coord = $k * $length + $transcript_start;
						print "$lncrna_part_color\t<a href = $cantata_link>$lncrna_name</a> (lncRNA)\n$bars_part_color\n$transcript_part_color\t<a href = $ensembl_link>$transcript_name</a>\n\n";
		
		

						}
	
					print "</pre>";
	
	
				function generate_id($id)
					{
					$length = strlen($id);
					for($i = 0; $i < (7-$length); $i++)
						{
						$id = '0' . $id;
						}
					$id = 'CNT' . $id;
					return $id;
					}
			?>
	
			
			<br /><br />
			<br /><h4>The alignment in a context of the gene structure</h4><hr /><br />

			<table><tr><td><img src = 'img/green.PNG' width = 100 style = "opacity: 0.3; z-index: 1; border-top: 5px solid red;" height = 40> </td><td>&nbsp;&nbsp;Region of lncRNA-RNA base-pairing</td></tr></table>

			<br />
			
			Set a new image width: <br/>
			<div class='btn-group' role='group' aria-label='...'>
				<button class='btn btn-default' id="b6_auto">Auto width</button>
				<button class='btn btn-default' id="b1">500px</button>
				<button class='btn btn-default' id="b2">1000px</button>
				<button class='btn btn-default' id="b3">2000px</button>
				<button class='btn btn-default' id="b4">5000px</button>
			</div>
			<br/><br/>

			<script>
				var transcript_id = "<?php echo $transcript_id; ?>";
				var alignment_key = "<?php echo $alignment_key; ?>";
				var species = "<?php echo $species; ?>";
				showHint(document.getElementById("aln").offsetWidth, transcript_id, alignment_key, species, 'true');

				var b1 = document.getElementById('b1'), b2 = document.getElementById('b2'), b3 = document.getElementById('b3'), b4 = document.getElementById('b4'), b5 = document.getElementById('b6_auto');
				b1.onclick = function() {
				showHint(500, transcript_id, alignment_key, species, 'false');

				};
				b2.onclick = function() {
				showHint(1000, transcript_id, alignment_key, species, 'false');
				};
				b3.onclick = function() {
				showHint(2000, transcript_id, alignment_key, species, 'false');
				};
				b4.onclick = function() {
				showHint(5000, transcript_id, alignment_key, species, 'false');
				};
				b6_auto.onclick = function() {
				showHint(document.getElementById("aln").offsetWidth, transcript_id, alignment_key, species, 'true');
				};
			</script>



			<script>

			//var size = 20;

			</script>
			</form>
			<p><span id="txtHint">Fetching data... (please refresh the page if you still can see this message; please avoid <i>right-click</i> page opening to avoid this in the future)<br /><img src = 'img/712.GIF'></span></p>
		</div>
	</div>
	
    <!-- Footer -->
    <?php include("footer.php"); ?>
    <!-- End of Footer -->
	
	
	
	

    <!-- jQuery -->
    <!--  <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
