<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<style type="text/css" class="init">
		th.wrappings, td.wrappings { white-space: nowrap; }
		div.dataTables_wrapper {
			width: 1500px;
			margin: 0 auto;
		}
		.vcenter 
		{
			display: inline-block;
			vertical-align: middle;
			float: none;
		}
	</style>
	
	<script src="js/jquery.js"></script>
	<script src="js/bootstrap.min.js"></script>
	
	
</head>

<body>
    <!-- Navigation -->
    <?php include("nav.php"); ?>
	<!-- End of Navigation -->
	
    <!-- Page Content -->
    
    <?php
		include("DatabaseConnect.php");
		
		$species_list = array('arabidopsis' => 'A. thaliana', 'amborella' => 'A. trichopoda', 'glycine' => 'G. max', 'oryza' => 'O. sativa', 'zea' => 'Z. mays', 'vitis' => 'V. vinifera', 'potato' => 'S. tuberosum', 'selaginella' => 'S. moellendorffii', 'physcomitrella' => 'P. patens', 'chlamydomonas' => 'C. reinhardtii');
		$species_list_full = array('arabidopsis' => 'Arabidopsis thaliana', 'amborella' => 'Amborella trichopoda', 'glycine' => 'Glycine max', 'oryza' => 'Oryza sativa', 'zea' => 'Zea mays', 'vitis' => 'Vitis vinifera', 'potato' => 'Solanum tuberosum', 'selaginella' => 'Selaginella moellendorffii', 'physcomitrella' => 'Physcomitrella patens', 'chlamydomonas' => 'Chlamydomonas reinhardtii');
	
		if(isset($_POST['id_selected']))
			{
			$id_selected = $_POST['id_selected'];
			$id_selected_for_display = $id_selected;
			$id_selected = raw_id($id_selected);
			}
		elseif(isset($_GET['id_selected']))
			{
			$id_selected = $_GET['id_selected'];
			$id_selected_for_display = $id_selected;
			}
		else
			{
			$id_selected = '';
			$id_selected_for_display = '';
			}
	
		if($id_selected)
			{
			$query_species = "select species from lncrnas where id = '$id_selected';";
			if (!($result_species = @ mysql_query($query_species)))
				die ("Could not execute mySQL query: species");
			$this_species = mysql_result($result_species,0,"species"); 
			}	
		else
			{
			$this_species = '';
			}
				
		if(!$this_species)
			{
			if(isset($_GET['species']))
				{
				$species = $_GET['species'];
				}
			elseif(isset($_POST['species']) && !(isset($_GET['species'])))
				{
				$species = $_POST['species'];
				}
			else
				{
				$species = 'arabidopsis';
				}
			}
		else
			{
			$species = $this_species;
			}



	?>
    
    
    <div class="container">
        <div class="row">
            <div class="col-sm-12 col-lg-10">
            	<?php 
					if(isset($_POST['id_selected']))
						{
						$id_selected = $_POST['id_selected'];
						$id_selected_for_display = $id_selected;
						$id_selected = raw_id($id_selected);
						}
					elseif(isset($_GET['id_selected']))
						{
						$id_selected = $_GET['id_selected'];
						$id_selected_for_display = $id_selected;
						}
					else
						{
						$id_selected = '';
						$id_selected_for_display = '';
						}
					
					if(isset($_GET['page']))
						{$page = $_GET['page'];}
					elseif(isset($_POST['page']) && !(isset($_GET['page'])))
						{$page = $_POST['page'];}
					else
						{$page = 1;}
						
					#if(isset($_POST['cpc_status_selected']))
					#	{
					#	$cpc_status_selected = $_POST['cpc_status_selected'];
					#	}
					#elseif(isset($_GET['cpc_status_selected']))
					#	{
					#	$cpc_status_selected = $_GET['cpc_status_selected'];
					#	}
					#else
					#	{
					#	$cpc_status_selected = '';
					#	}

					#if(isset($_POST['max_peptide_length_selected']))
					#	{
					#	$max_peptide_length_selected = $_POST['max_peptide_length_selected'];
					#	}
					#elseif(isset($_GET['max_peptide_length_selected']))
					#	{
					#	$max_peptide_length_selected = $_GET['max_peptide_length_selected'];
					#	}
					#else
					#	{
					#	$max_peptide_length_selected = 1000000;
					#	}

					#if(isset($_POST['max_expression_selected']))
					#	{
					#	$max_expression_selected = $_POST['max_expression_selected'];
					#	}
					#elseif(isset($_GET['max_expression_selected']))
					#	{
					#	$max_expression_selected = $_GET['max_expression_selected'];
					#	}
					#else
					#	{
					#	$max_expression_selected = -1;
					#	}
	
					#if(isset($_POST['event_selected']))
					#	{
					#	$event_selected = $_POST['event_selected'];
					#	}
					#elseif(isset($_GET['event_selected']))
					#	{
					#	$event_selected = $_GET['event_selected'];
					#	}
					#else
					#	{
					#	$event_selected = '';
					#	}
					#if(isset($_POST['biotype_selected']))
					#	{
					#	$biotype_selected = $_POST['biotype_selected'];
					#	}
					#elseif(isset($_GET['biotype_selected']))
					#	{
					#	$biotype_selected = $_GET['biotype_selected'];
					#	}
					#else
					#	{
					#	$biotype_selected = 'protein_coding';
					#	}
					
					

            		#################################################################	CONFIDENCE
            		if(isset($_POST['results_confidence']))
					{
						$results_confidence = $_POST['results_confidence'];
						$confidenceString = " and confidence like '$results_confidence'";
					}
					elseif(isset($_GET['results_confidence']))
					{	
						$results_confidence = $_GET['results_confidence'];
						$confidenceString = " and confidence like '$results_confidence'";
					}
					else
					{
						$results_confidence = '';
						$confidenceString = "";
					}
					if ($results_confidence == 'Yes')
						{$confidenceString = " and confidence like '1'";}
					elseif ($results_confidence == 'No')
						{$confidenceString = " and confidence like '0'";}
					else
					{	
						$confidenceString = "";
						$results_confidence = "All";
					}
					#################################################################	CNCI STATUS
					if(isset($_POST['cnci_status_selected']))
					{
						$cnci_status_selected = $_POST['cnci_status_selected'];
						$cnciString = " and cnci_status like '$cnci_status_selected%'";
					}
					elseif(isset($_GET['cnci_status_selected']))
					{
						$cnci_status_selected = $_GET['cnci_status_selected'];
						$cnciString = " and cnci_status like '$cnci_status_selected%'";
					}
					else
					{
						$cnci_status_selected = '';
						$cnciString = "";
					}	
					#################################################################	MAX PEPTIDE LENGTH	 
            		if(isset($_POST['max_peptide_length_selected']))
					{
						$max_peptide_length_selected = $_POST['max_peptide_length_selected'];
						$maxPepLen = " and max_peptide_length < '$max_peptide_length_selected'";
					}
					elseif(isset($_GET['max_peptide_length_selected']))
					{
						$max_peptide_length_selected = $_GET['max_peptide_length_selected'];
						$maxPepLen = " and max_peptide_length < '$max_peptide_length_selected'";
					}
					else
					{
						$max_peptide_length_selected = 1000000;
						$maxPepLen = "";
					}
            		#################################################################	No. of exons SELECTED
            		if(isset($_POST['no_of_exons_selected']) and $_POST['no_of_exons_selected'])
					{
						$no_of_exons_selected = $_POST['no_of_exons_selected'];
						
						$exonsString = " and no_of_exons = $no_of_exons_selected";
					}
					elseif(isset($_GET['event_selected']) and $_GET['no_of_exons_selected'])
					{
						$no_of_exons_selected = $_GET['no_of_exons_selected'];
						
						$exonsString = " and no_of_exons = $no_of_exons_selected";
					}
					else
					{
						$no_of_exons_selected = '';
						$exonsString = "";
					}
            		#################################################################	MAX EXPRESSION SELECTED
            		if(isset($_POST['max_expression_selected']))
					{
						$max_expression_selected = $_POST['max_expression_selected'];
						$maxExprString = " and max_expression > '$max_expression_selected'";
					}
					elseif(isset($_GET['max_expression_selected']))
					{
						$max_expression_selected = $_GET['max_expression_selected'];
						$maxExprString = " and max_expression > '$max_expression_selected'";
					}
					else
					{
						$max_expression_selected = -1;
						$maxExprString = " and max_expression > '$max_expression_selected'";
					}
					#################################################################	BIOTYPE SELECTED
					if(isset($_POST['biotype_selected']))
					{
						$biotype_selected = $_POST['biotype_selected'];
						$biotypeString = " and max_expression > '$biotype_selected'";
					}
					elseif(isset($_GET['biotype_selected']))
					{
						$biotype_selected = $_GET['biotype_selected'];
						$biotypeString = " and max_expression > '$biotype_selected'";
					}
					else
					{
						$biotype_selected = 'protein_coding';
						$biotypeString = "";
					}
					#################################################################	ORDER
					
					if(isset($_POST['postableOrder']))
					{
						$postableOrder = $_POST['postableOrder'];
					}
					elseif(isset($_GET['postableOrder']))
					{
						$postableOrder = $_GET['postableOrder'];
					}
					else
					{
						$postableOrder = 'id_DESC';
					}	
            		
            		if($postableOrder == 'id_DESC')
						{$order = 'id DESC';}
					elseif($postableOrder == 'id_ASC')
						{$order = 'id ASC';}
					elseif($postableOrder == 'uniprot_evalue_DESC')
						{$order = 'uniprot_evalue DESC';}
					elseif($postableOrder == 'uniprot_evalue_ASC')
						{$order = 'uniprot_evalue ASC';}
					elseif($postableOrder == 'max_expression_DESC')
						{$order = 'max_expression DESC';}
					elseif($postableOrder == 'max_expression_ASC')
						{$order = 'max_expression ASC';}
					elseif($postableOrder == 'max_peptide_length_DESC')
						{$order = 'max_peptide_length DESC';}
					elseif($postableOrder == 'max_peptide_length_ASC')
						{$order = 'max_peptide_length ASC';}
            		
            		print "<form action = 'search.php' method = 'POST' >
							<h3><b><span class='glyphicon glyphicon-search' aria-hidden='true'></span> SEARCH OPTIONS</b></h3>
							<div class='table-responsive'>
								<table class = 'table'>
									<tr>
										<th>lncRNA id</th>
										<td>
										<input type = hidden name = 'page' value = 1>
										<input type = hidden name = 'species' value = $species>
										<input name = 'id_selected' value = '' class='form-control' placeholder='eg. CNT2089162 (in A. thaliana)'></td>
									</tr>
									<tr>
										<th title = 'Coding Potential Calculator status'>CNCI status</th>
										<td><select name = 'cnci_status_selected' class='form-control'>
                                    			<option value = ''>Select</option>
                                    			<option value = 'coding'>coding</option>
                                    			<option value = 'noncoding'>noncoding</option>
                                			</select>
										</td>
									</tr>
									<tr>
										<th>Max. peptide length</th>
										<td><select name = 'max_peptide_length_selected' class='form-control'>
                                    			<option value = '1000000'>Select</option>
                                    			<option value = '30'>< 30 AA</option>
                                    			<option value = '50'>< 50 AA</option>
                                    			<option value = '100'>< 100 AA</option>
                                    			<option value = '200'>< 200 AA</option>
                                			</select>
										</td>
									</tr>
									<tr>
										<th>Max. expression</th>
										<td><select name = 'max_expression_selected' class='form-control'>
                                    			<option value = '-1'>Select</option>
                                    			<option value = '1'>> 1 RPKM</option>
                                    			<option value = '10'>> 10 RPKM</option>
                                    			<option value = '25'>> 25 RPKM</option>
                                    			<option value = '100'>> 100 RPKM</option>
                                			</select>
										</td>
									</tr>
									<tr>
										<th>No. of exons</th>
										<td>										
											<input name = 'no_of_exons_selected' value = '' class='form-control' placeholder='eg. 3'></td>
										</td>
									</tr>
									<tr>
										<th>Results confidence</th>
										<td><select name = 'results_confidence' class='form-control'>
                                    			<option value = 'All'>Show all</option>
                                    			<option value = 'Yes'>Confident lncRNAs</option>
                                    			<option value = 'No'>Low-confidence lncRNAs</option>
                                			</select>
										</td>
									</tr>
									<tr>
										<th>Order results by</th>
										<td><select name = 'postableOrder' class='form-control'>
                                    			<option value = 'id_DESC'>lncRNA id (descending)</option>
                                    			<option value = 'id_ASC'>lncRNA id (ascending)</option>
                                    			<option value = 'uniprot_evalue_DESC'>Swiss-Prot E-value (descending)</option>
                                    			<option value = 'uniprot_evalue_ASC'>Swiss-Prot E-value (ascending)</option>
                                    			<option value = 'max_expression_DESC'>Max. expression (descending)</option>
                                    			<option value = 'max_expression_ASC'>Max. expression (ascending)</option>
                                    			<option value = 'max_peptide_length_DESC'>Max. peptide length (ascending)</option>
                                    			<option value = 'max_peptide_length_ASC'>Max. peptide length (acending)</option>
                                			</select>
										</td>
									</tr>  
								</table>
							</div>
							<input type='submit' value='Search' class='btn btn-primary'  />
						</form>";
		
					print "<hr />";
    				
    				////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					if($id_selected)
					{
						#$query = "select * from lncrnas where species = '$species' and id = '$id_selected' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						$query = "select * from lncrnas where id = '$id_selected';";
						
					}
					else
					{
						#$query = "select * from lncrnas where species = '$species' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						# order by $order;";
						$query = "select * from lncrnas where species = '$species' $cnciString $maxPepLen $exonsString $confidenceString $maxExprString order by $order;";

					}
					#print $query;
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////


					if (!($result = @ mysql_query($query)))
						die ("Could not execute mySQL query");

					$number = mysql_numrows($result);
					
					if($number)
					{
						$codingNumber = 0;
						$noncodingNumber = 0;
						
						$miRNAsNumber = 0;
						$splicingsNumber = 0;
						$miSplicNumber = 0;
						$noFuncNumber = 0;
						for($i=0; $i<$number; $i++)
						{
							$cnciStat = mysql_result($result,$i,"cnci_status"); 
							if ($cnciStat == 'coding')
								{$codingNumber++;}
							if ($cnciStat == 'noncoding')
								{$noncodingNumber++;}
							$tmpFunctions = mysql_result($result,$i,"events_string"); 
							if ($tmpFunctions == 'miRNA')
								{$miRNAsNumber++;}
							elseif ($tmpFunctions == 'splicing')
								{$splicingsNumber++;}
							elseif ($tmpFunctions == 'splicing, miRNA')
								{$miSplicNumber++;}
							else
								{$noFuncNumber++;}

						}
					}
    print "</div></div></div>";
    $species_full = $species_list_full[$species];
    ?>
    <div class='container'>
    	<div class='row'>
    		<div class="col-lg-4 col-sm-4">
				<div class="panel panel-info">
					<div class="panel-heading">
						<h3 class="panel-title">Current search details:</h3>
					</div>
					<div class="panel-body">
						<?php 
							print "Found <b>$number</b> records<br/><br/>"; 
							if($id_selected)
							{
								print "<b>lncRNA ID</b>: $id_selected_for_display<br />";
							}
							else
							{
								print "<table>";
								$inactiveColor = '#bfbfbf';
								$fontSize = 2;
								
								if($cpc_status_selected)
								{
									print " <tr title='Filters used within this search'>
												<td><b title = 'Coding Potential Calculator status'>CNCI status:</b></td>
												<td>&nbsp; $cnci_status_selected</td>
											</tr>";
								}
								else
								{
									print " <tr>
												<td><font color=$inactiveColor size=$fontSize><b>CNCI status:</b></font></td>
												<td><font color=$inactiveColor size=$fontSize>&nbsp; #</font></td>
											</tr>";
								}
								
								if($max_peptide_length_selected < 1000000)
								{
									print " <tr>
												<td><font size=$fontSize><b>Max. peptide length:</b></font></td>
												<td><font size=$fontSize>&nbsp; < $max_peptide_length_selected AA</font></td>
											</tr>";
								}
								else
								{
									print " <tr>
												<td><font color=$inactiveColor size=$fontSize><b>Max. peptide length:</b></font></td>
												<td><font color=$inactiveColor size=$fontSize>&nbsp; #</font></td>
											</tr>";
								}
								
								if($max_expression_selected > -1)
								{
									print " <tr>
												<td><font size=$fontSize><b>Max. expression:</b></font></td>
												<td><font size=$fontSize>&nbsp; > $max_expression_selected RPKM</font></td>
											</tr>";
								}
								else
								{
									print " <tr>
												<td><font color=$inactiveColor size=$fontSize><b>Max. expression:</b></font></td>
												<td><font color=$inactiveColor size=$fontSize>&nbsp; #</font></td>
											</tr>";
								}
								
								if($no_of_exons_selected)
								{
									print " <tr>
												<td><font size=$fontSize><b>No. of exons:</b></font></td>
												<td><font size=$fontSize>&nbsp; $no_of_exons_selected</font></td>
											</tr>";
								}
								else
								{
									print " <tr>
												<td><font color=$inactiveColor size=$fontSize><b>No. of exons:</b></font></td>
												<td><font color=$inactiveColor size=$fontSize>&nbsp; #</font></td>
											</tr>";
								}
								
								if($results_confidence == 'All')
								{
									print " <tr>
												<td><font size=$fontSize><b>Results confidence:</b></font></td>
												<td><font size=$fontSize>&nbsp; Show all</font></td>
											</tr>";
								}
								elseif($results_confidence == 'Yes')
								{
									print " <tr>
												<td><font size=$fontSize><b>Results confidence:</b></font></td>
												<td><font size=$fontSize>&nbsp; only <b>high</b> confidence results</font></td>
											</tr>";
								}
								elseif($results_confidence == 'No')
								{
									print " <tr>
												<td><font size=$fontSize><b>Results confidence:</b></font></td>
												<td><font size=$fontSize>&nbsp; only <b>low</b> confidence results</font></td>
											</tr>";
								}
								
								if($order == 'id DESC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; lncRNA ID </font><span class='glyphicon glyphicon-triangle-bottom' aria-hidden='true'></span></td>
											</tr>";
								}
								elseif($order == 'id ASC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; lncRNA ID <span class='glyphicon glyphicon-triangle-top' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'uniprot_evalue DESC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Swiss-Prot E-value <span class='glyphicon glyphicon-triangle-bottom' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'uniprot_evalue ASC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Swiss-Prot E-value <span class='glyphicon glyphicon-triangle-top' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'max_expression DESC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Max. expression <span class='glyphicon glyphicon-triangle-bottom' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'max_expression ASC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Max. expression <span class='glyphicon glyphicon-triangle-top' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'max_peptide_length DESC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Max. peptide length <span class='glyphicon glyphicon-triangle-bottom' aria-hidden='true'></span></font></td>
											</tr>";
								}
								elseif($order == 'max_peptide_length ASC')
								{
									print " <tr>
												<td><font size=$fontSize><b>Order by:</b></font></td>
												<td><font size=$fontSize>&nbsp; Max. peptide length <span class='glyphicon glyphicon-triangle-top' aria-hidden='true'></span></font></td>
											</tr>";
								}
								print "</table><br/>";
							}
							print "
							<form action = 'DOWNLOADS/download_current.php' method = 'POST' >
								<input type = hidden name = 'species' value = $species_full_space>
								<input type = hidden name = 'queryToSave' value = ";?>"<?php print "$query";?>"<?php print ">
								<input type = hidden name = 'cnci_status_selected' value = $cpc_status_selected>
								<input type = hidden name = 'max_peptide_length_selected' value = $max_peptide_length_selected>
								<input type = hidden name = 'max_expression_selected' value = $max_expression_selected>
								<input type = hidden name = 'no_of_exons_selected' value = $no_of_exons_selected>
								<input type = hidden name = 'results_confidence' value = $results_confidence>
								<input type = hidden name = 'order' value = '$order'>
								<input type='submit' value='Download current results' class='btn btn-default btn-block'/>
							</form>";
						?>
					</div>
				</div>
			</div>
			<!-- <div class="col-lg-8 col-sm-8">
				<br/><br/>
				<div class = "col-lg-6 col-sm-6" id="cpc"  style="height: 250px; "></div>
				<div class = "col-lg-6 col-sm-6" id="functions" style="height: 250px; "></div>
			</div> -->
			<div class = "col-lg-4 col-sm-4" id="cpc"  style="height: 250px; "></div>
			<?php $sp = str_replace('_', ' ', $species); ?>
			<div class = "col-lg-4 col-sm-4"><img src = <?php print "img/$species.jpg title = \"$sp\""; ?> height = 250></div>
		</div>
		<hr/>
	</div>
    
    <div class='container'>
		<?php
			$records_per_page = 50;
			$nr_of_pages = ceil($number / $records_per_page);
			$start = ($page - 1) * $records_per_page;
			$end = $start + $records_per_page;
			$end = min($number, $end);
			$next = $page + 1;
			$prev = $page - 1;
			
			####### PAGINATION #######
			include('pagination.php');
			##### PAGINATION END #####
			
					if($number)
						{
						print "
							<div class='dataTables_wrapper'>
    							<section>
    								<div class='table-responsive'>
										<table class='table table-bordered table-hover table-striped'  style='width: 1000 important!;'>
											<thead>
												<tr>
													<th nowrap>Record details</th>
													<th>CANTATAdb ID</th> 
													<th>Species</th> 
													<th>Location</th> 
													<th class='wrappings' title = 'CNCI status'>CNCI status (score)</th> 
													<th class='wrappings'>Swiss-Prot best hit</th> 
													<th class='wrappings'>Max. peptide length</th> 
													<th class='wrappings'>Max. expression</th> 
													<th class='wrappings'>No. of exons</th>
													<th class='wrappings'>Confidence</th>
												</tr>
											</thead>
											<tbody>
							  ";
						
						for($i=$start; $i<$end; $i++)
							{
							$j = $i + 1;
							$id = mysql_result($result,$i,"id");  
							$this_species = mysql_result($result,$i,"species");  
							$transcript = mysql_result($result,$i,"transcript");  
							$gene = mysql_result($result,$i,"gene");  
							$cnci_status = mysql_result($result,$i,"cnci_status");  
							$cpc_status = mysql_result($result,$i,"cpc_status");  
							$cnci_score = mysql_result($result,$i,"cnci_score");  
							$blast_noncode_arabidopsis = mysql_result($result,$i,"blast_noncode_arabidopsis");  
							$blast_pnrd_populus = mysql_result($result,$i,"blast_pnrd_populus");  
							$blast_pnrd_oryza = mysql_result($result,$i,"blast_pnrd_oryza");  
							$blast_pnrd_zea = mysql_result($result,$i,"blast_pnrd_zea");  
							$blast_uniprot = mysql_result($result,$i,"blast_uniprot");  
							$reciprocal = mysql_result($result,$i,"reciprocal");  
							$predicted_hits = mysql_result($result,$i,"predicted_hits");  
							$max_peptide_length = mysql_result($result,$i,"max_peptide_length");
							$confidence_val = mysql_result($result,$i,"confidence");
							if ($confidence_val == 1)
								{$confidence = 'Yes';}
							else
								{$confidence = 'No';}
	
							if($max_peptide_length == 0)
								{
								$max_peptide_length = '-';
								}
	
							$uniprot_hit = explode('*', $blast_uniprot);
							$uniprot_hit = $uniprot_hit[0];
							$uniprot_id = explode('|', $uniprot_hit);
							$uniprot_id = $uniprot_id[1];
							$uniprot_link = "http://www.uniprot.org/uniprot/" . $uniprot_id;

	
							$uniprot_evalue = mysql_result($result,$i,"uniprot_evalue");  
							$events_string = mysql_result($result,$i,"events_string");  
							$events_string = str_replace('miRNA', 'miRNA-associated', $events_string);
							$events_string = str_replace('splicing', 'splicing regulation', $events_string);
							$chr = mysql_result($result,$i,"chr");  
							$this_start = mysql_result($result,$i,"start");  
							$this_end = mysql_result($result,$i,"end");  
							$strand = mysql_result($result,$i,"strand");  
							$max_expression = mysql_result($result,$i,"max_expression");  
							$no_of_exons = mysql_result($result,$i,"no_of_exons");  
	
							#$species_full = $species_list_full[$species];
							#$species_full = str_replace(' ', '_', $species_full);
							$ensembl_link = "http://plants.ensembl.org/" . $species . "/Location/View?db=core;r=" . $chr . ':' . $this_start . '-' . $this_end;
							$species_full = $species;
	
	
	
							//$this_species = $species_list[$this_species];
	
							$display_id = generate_id($id);
	
							$species_full_space = str_replace('_', ' ', $species_full);

							$mainQueryLink = "search.php?page=$page&postableOrder=$postableOrder&species=$species&id_selected=$id_selected&no_of_exons_selected=$no_of_exons_selected&cnci_status_selected=$cnci_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&results_confidence=$results_confidence&postableOrder=$postableOrder";
							#print "<br/>$mainQueryLink<br/>";
							if ($confidence_val == 1)
								{print "<tr>";}
							else
								{print "<tr class='danger'>";}
							print "
									<td align=center>
									<form action = 'details.php' method = 'POST' >
										<input type = hidden name = 'species' value = $species>
										<input type = hidden name = 'id' value = $id>
										<input type = hidden name = 'mainQueryLink' value = $mainQueryLink>
										<input type='submit' value='&raquo; Details &raquo;' class='btn btn-sm btn-success'/>
									</form>
									<td>$display_id</td>
									<td nowrap><i>$species_full_space</i></td>
									<td nowrap><a href = $ensembl_link title = 'View the region at Ensembl Plants'>$chr:$this_start-$this_end ($strand)</a></td>
									<td>$cnci_status ($cnci_score)</td>";
									if($uniprot_evalue > -1)
										{
										print "<td>$uniprot_evalue (<a href = $uniprot_link>$uniprot_hit</a>)</td>";
										}
									else
										{
										print "<td>-</td>";                
										}
									print "
									<td>$max_peptide_length</td>
									<td>$max_expression</td>
									<td>$no_of_exons</td>";
									if ($confidence_val == 1)
										{print "<td><font color=green>Confident lncRNA</font></td>";}
									else
										{print "<td title='View record details for more information'><font color=red><b>Low-confidence lncRNA</b></font></td>";}
									print "
								</tr>";
							}

			
						print "</tbody></table></div>";   
						}

/*
					function generate_id($id)
						{
						$length = strlen($id);
						for($i = 0; $i < (7-$length); $i++)
							{
							$id = '0' . $id;
							}
						$id = 'CNT' . $id;
						return $id;
						}

					function raw_id($id)
						{
						$id = str_replace('CNT', '', $id);
						$id = intval($id);
						return $id;
						}    
*/
					function generate_id($id)
						{
						return $id;
						}

					function raw_id($id)
						{
						return $id;
						}    



            	####### PAGINATION #######
				include('pagination.php');
				##### PAGINATION END #####
            	
            	?>
            
            
                
            </section>
         </div>
    </div>
    
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.js"></script>

		<?php
			print "
				<script type='text/javascript'>
					jQuery.noConflict();
					(function($){
						$(function () {
							$('#cpc').highcharts({
								chart: {
									plotBackgroundColor: null,
									plotBorderWidth: 0,
									plotShadow: false
								},
								title: {
									text: 'CNCI status',
									align: 'center',
									verticalAlign: 'top',
									style: { 'color': '#333333', 'fontSize': '15px' }
								},
								tooltip: {
									pointFormat: '{series.name}<b>{point.percentage:.1f}% of shown results</b>'
								},
								plotOptions: {
									pie: {
										dataLabels: {
											enabled: false,
											distance: -50,
											style: {
												fontWeight: 'bold',
												color: 'white',
												textShadow: '0px 1px 2px black'
											}
										},
										showInLegend: true,
										center: ['50%', '65%']
									}
								},
								credits: {
									enabled: false
								},
								series: [{
									type: 'pie',
									name: ' ',
									innerSize: '50%',
									data: [
										['Coding - #$codingNumber',   $codingNumber],
										['Noncoding - #$noncodingNumber',       $noncodingNumber]
									]
								}]
							});
						});
					})(jQuery);
				</script>"; ?>
		
		<?php
			print "
				<script type='text/javascript'>
					jQuery.noConflict();
					(function($){
						$(function () {
							$('#functions').highcharts({
								chart: {
									plotBackgroundColor: null,
									plotBorderWidth: 0,
									plotShadow: true
								},
								title: {
									text: 'Potential functions',
									align: 'center',
									verticalAlign: 'top',
									style: { 'color': '#333333', 'fontSize': '15px' }
								},
								tooltip: {
									pointFormat: '{series.name}<b>{point.percentage:.1f}% of shown results</b>'
								},
								plotOptions: {
									pie: {
										dataLabels: {
											enabled: false,
											distance: 0,
											style: {
												fontWeight: 'bold',
												color: 'white',
												textShadow: '0px 1px 2px black'
											}
										},
										showInLegend: true,
										center: ['50%', '65%']
									}
								},
								credits: {
									enabled: false
								},
								series: [{
									type: 'pie',
									name: ' ',
									innerSize: '50%',
									data: [
										['[1] miRNA-associated - #$miRNAsNumber',   $miRNAsNumber],
										['[2] Splicing regulation - #$splicingsNumber',   $splicingsNumber],
										['[1] and [2] - #$miSplicNumber',   $miSplicNumber],
										['No function detected - #$noFuncNumber',       $noFuncNumber]
									]
								}]
							});
						});
					})(jQuery);
				</script>"; ?>
		
		
		<script src="Highcharts-4.1.6/js/highcharts.js"></script>
		<script src="Highcharts-4.1.6/js/modules/exporting.js"></script>
		

	</div>	
    <!-- Footer -->
    <?php include("footer.php"); ?>
    <!-- End of Footer -->
	
	
	
	

    <!-- jQuery -->
    <!--  <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
