<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<!-- advice from http://stackoverflow.com/questions/22268374/changing-the-width-of-twitter-bootstrap-popover -->
	<style type="text/css" class="init">

	th.wrappings, td.wrappings { white-space: nowrap; }
	div.dataTables_wrapper {
		width: 1400px;
		margin: 0 auto;
	}
	
	
	.popover
	{
    	width:auto;
    	max-width: none;
    	height:auto;    
	}

	</style>
	<script src="js/jquery.js"></script>
	<script src="js/bootstrap.min.js"></script>
</head>



<body>

    <!-- Navigation -->
    <?php include("nav.php"); ?>
	<!-- End of Navigation -->

    <!-- Page Content -->
    <?php 
    	include("DatabaseConnect.php"); 
    	$id = $_GET['id'];
		$id = explode('*', $id);
		$target = $id[0];
		$lncrna = $id[1];
		$alignment_start = $id[2];
		$alignment_end = $id[3];
		$al_start = $alignment_start;

		$alignment_key = $_GET['id'];
		$species = $_GET['species'];
		$database1 = 'alignment_ids';

		$species_array = array('amborella' => 'Amborella_trichopoda', 'arabidopsis' => 'Arabidopsis_thaliana', 'chlamydomonas' => 'Chlamydomonas_reinhardtii', 'glycine' => 'Glycine_max', 'physcomitrella' => 'Physcomitrella_patens', 'potato' => 'Solanum_tuberosum', 'selaginella' => 'Selaginella_moellendorffii', 'vitis' => 'Vitis_vinifera', 'zea' => 'Zea mays', 'oryza' => 'Oryza_sativa');
		$species_list_full = array('arabidopsis' => 'Arabidopsis thaliana', 'amborella' => 'Amborella trichopoda', 'glycine' => 'Glycine max', 'oryza' => 'Oryza sativa', 'zea' => 'Zea mays', 'vitis' => 'Vitis vinifera', 'potato' => 'Solanum tuberosum', 'selaginella' => 'Selaginella moellendorffii', 'physcomitrella' => 'Physcomitrella patens', 'chlamydomonas' => 'Chlamydomonas reinhardtii');

		$data = explode('*', $alignment_key);
		$transcript_name = $data[0];
		$id = $data[1];
		$lncrna_name = $data[1];
		$lncrna_name = generate_id($lncrna_name);
		
		$mainQueryLink = $_POST['mainQueryLink'];
		$codedMainQueryLink = str_replace('=', '*', $mainQueryLink);
		$codedMainQueryLink = str_replace('&', '(', $codedMainQueryLink);
		$codedMainQueryLink = str_replace('search.php?', 'FrOnTuRl', $codedMainQueryLink);

	?>
		
    <div class="row">
		<div class="container">
			<div class="btn-group" role="group" aria-label="...">
				<?php print "<a class='btn btn-default' href='$mainQueryLink'>&laquo; Back to <b><i>$species_list_full[$species]</i></b> search</a>";?>
				<?php print "<a class='btn btn-default' href='details.php?id=$lncrna&species=$species&mainQueryLink=$codedMainQueryLink'>&laquo; Back to <b>$lncrna_name</b> details page</a>";?>
			</div>
			<br/>
			<br/>
			<ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#targets">miRNA targets</a></li>
				<li><a data-toggle="tab" href="#pairing">lncRNA-RNA base pairing</a></li>
			</ul>
			<br>
			<div class="tab-content">
				<div id="targets" class="tab-pane fade in active text-left">
				
					<h6 style='color:grey'>* Click miRNA sequence to see alignment details</h6><br/>

					<?php
						$query_targets = "select * from targets where target = '$target' and target_start >= $alignment_start and target_end <= $alignment_end order by target_start, mirna;";

						if (!($result_targets = @ mysql_query($query_targets)))
							die ("Could not execute mySQL query: targets");

						$number_targets = mysql_numrows($result_targets);

						$dict_targets = array();
						$dict_targets_details = array();

						for($n=0; $n<$number_targets; $n++)
							{
							$mirna = mysql_result($result_targets,$n,"mirna");  
							$target_start = mysql_result($result_targets,$n,"target_start");  
							$target_end = mysql_result($result_targets,$n,"target_end");  
							$target = mysql_result($result_targets,$n,"target");  
							$mechanism = mysql_result($result_targets,$n,"mechanism");  
							$expectation = mysql_result($result_targets,$n,"expectation");  
							$UPE = mysql_result($result_targets,$n,"UPE");  
							$mirna_fragment = mysql_result($result_targets,$n,"mirna_fragment");  
							$target_fragment = mysql_result($result_targets,$n,"target_fragment");  
							$bars = mysql_result($result_targets,$n,"bars");  
							$dict_targets[] = $mirna . '*' . $target_start . '*' . $mirna_fragment;
							$dict_targets_details[] = $mirna . '*' . $target_start . '*' . $target_end . '*' . $mirna_fragment . '*' . $target_fragment . '*' . $bars . '*' . $mechanism . '*' . $expectation . '*' . $UPE;

							}
	
						////////////////////////////////////////////////////////////////////////////////
						// get alignment id

						$alignment_key = $_GET['id'];
						$species = $_GET['species'];

						$database1 = 'alignment_ids';

						$query_id = "select * from $database1 where id = '$alignment_key';";


						if (!($result_id = @ mysql_query($query_id)))
							die ("Could not execute mySQL query: id");

	


							$alignment_id = mysql_result($result_id,0,"alignment_id"); 
	
	
							$alignment_key2 = explode('*', $alignment_key);
							$transcript_id = $alignment_key2[0];
	
							print "<h4>miRNA targets for $target in lncRNA-interacting region</h4>";
	
	
	
							$database2 = 'alignments';
							$query = "select * from $database2 where alignment_id = '$alignment_id';";
						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////


						if (!($result = @ mysql_query($query)))
							die ("Could not execute mySQL query");

	


							$lncrna_sequence = mysql_result($result,0,"lncrna_sequence");  
							$bars = mysql_result($result,0,"bars");  
							$alignment_bars = $bars;
							$transcript_sequence = mysql_result($result,0,"transcript_sequence");  
	
							$sequence = $transcript_sequence;

							$sequence = strtoupper($sequence);
							$sequence = str_replace('-', '', $sequence);
	

							function format_sequence($s)
							  {
							  $sequence = '';
							  $flag = 1;
							  $count = 0;
							  for($i = 0; $i < strlen($s); $i++)
								  {
								  $elem = $s[$i];
								  if($elem == '<')
									  {
									  $flag = 0;
									  }
			  
								  if($flag == 1)
									  {
									  $count += 1;
									  }
								  if($elem == '>')
									  {
									  $flag = 1;
									  }
								  $sequence .= $elem;
								  if($count%170 == 0)
									  {
									  $sequence .= "<br />";
									  }
								  }
							  return "$sequence";
							  }
	  
						$rrr = format_sequence($sequence);


						// Get alignment coordiates on the chromosome

						////////////////////////////////////////////////////////////////////////////////
						// get alignment id

						$database3 = 'interactions';
						$query_coords = "select * from $database3 where id = '$alignment_key';";



						if (!($result_coords = @ mysql_query($query_coords)))
							die ("Could not execute mySQL query: id");

							$alignment_start = mysql_result($result_coords,0,"start"); 
							$alignment_end = mysql_result($result_coords,0,"end"); 
	

						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////
	
							$length = 100;
							print "<pre style='border:none; background:none'>";
	
							$lower_flag = 0;
							$upper_flag = 0;
							$prev_lower_flag = 0;
							$prev_upper_flag = 0;
	
							print "\n\n";
							$transcript_sequence = str_replace('-', '', $transcript_sequence);
							$chopped = array();
							for($k = 0; $k < ceil(strlen($transcript_sequence)/$length); $k++)
								{
								$start = $k * $length;
								$end = ($k+1) * $length;
								if($end > strlen($lncrna_sequence))
									{
									$end = strlen($lncrna_sequence);
									}
								$len = $end - $start;
								$lncrna_part = substr($lncrna_sequence, $start, $len);
								$bars_part = substr($bars, $start, $len);
								$transcript_part = substr($transcript_sequence, $start, $len);
		
								$transcript_part_color = '<span>';
								$lncrna_part_color = '<span>';
								$bars_part_color = '<span>';
								for ($n = 0; $n < strlen($transcript_part); $n++)
									{
									$transcript_nt = $transcript_part[$n];
									$bars_nt = $bars_part[$n];
									$lncrna_nt = $lncrna_part[$n];
			
									if(ctype_lower($transcript_nt))
									  {
									  $lower_flag = 1;
									  }
									else
									  {
									  $lower_flag = 0;
									  }
									if (($lower_flag && $prev_lower_flag == 0 && $transcript_nt != '-') || ($n ==0 && $lower_flag))
										{
										$transcript_part_color .= "</span><span style = 'background-color: lightyellow;'>";
										$bars_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
										$lncrna_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
										}
									if (($lower_flag == 0 && $prev_lower_flag == 1 && $transcript_nt != '-') || ($n ==0 && $lower_flag == 0))
										{
										$transcript_part_color .= "</span><span style = 'background-color: lightyellow;'>";
										$bars_part_color .= "</span><span style = 'background-color: #99FF99;'>";
										$lncrna_part_color .= "</span><span style = 'background-color: #99FF99;'>";
										}
									$transcript_part_color .= $transcript_part[$n];
									$bars_part_color .= $bars_part[$n];
									$lncrna_part_color .= $lncrna_part[$n];
			
									$prev_lower_flag = $lower_flag;
									}
								$transcript_part_color .= '</span>';
								$bars_part_color .= '</span>';
								$lncrna_part_color .= '</span>';
		
		
								$this_coord = $k * $length + $al_start + 1;
		
								foreach ($chopped as $key => $value)			
								{
									print "<a href='#' title='$mirna alignment details' data-toggle='popover' data-placement='bottom' data-content='$tooltip_text' data-html='true'>$value, $key</a><br />";
								}
								$chopped = array();
								for($p = 0; $p < count($dict_targets); $p++)
									{
									$data = $dict_targets[$p];
									$details = $dict_targets_details[$p];
									$d = $data;
									$data = explode('*', $data);
									$mirna = $data[0];
									$target_start = $data[1];
									$mirna_fragment = $data[2];
						
									if($target_start >= $this_coord && $target_start < $this_coord + $length)
										{
										$distance = $target_start - $this_coord;
										$string = '';
										$mirna_fragment = strrev($mirna_fragment);
										for($o = 0; $o < $distance; $o++)
											{
											$string .= ' ';
											}
										$m = $mirna_fragment;

										if($distance + strlen($mirna_fragment) > $length)
											{
											$l = strlen($mirna_fragment);
											$mirna_fragment = substr($mirna_fragment, 0, $length - $distance);
											$part = substr($m, $length - $distance);
											$chopped[$mirna] = $part;
											}
					
											if (($length-($distance + strlen($mirna_fragment))) >= 12)
											{
												if ($chopped == array())
													{$text = "<span id = 'text'>" . $mirna_fragment . ', ' . $mirna . '<br /></span>';}
												else
													{$text = "<span id = 'text'>" . $mirna_fragment . '<br /></span>';}
											}
											else
												{$text = "<span id = 'text'>" . $mirna_fragment . '<br /></span>';}
					
											$details = explode('*', $details);
											$target_end = $details[2];
											$target_fragment = $details[4];
											$bars = $details[5];
											$mechanism = $details[6];
											$expectation = $details[7];
											$UPE = $details[8];
											$target_rev = strrev($target_fragment);
											$bars_rev = strrev($bars);

											$tooltip_text = "<pre>$m&nbsp;&nbsp;<b>$mirna</b><br />$bars_rev<br />$target_rev&nbsp;&nbsp;<b>$target</b></pre>
											<br />
											<b>Coordinates on target sequence:</b> $target_start - $target_end<br />
											<b>Mechanism:</b> $mechanism<br />
											<b>Expectation:</b> $expectation <a href = http://plantgrn.noble.org/psRNATarget/?dowhat=Help#maxexpectation><img src = img/question.png width = 13></a><br />
											<b>UPE:</b> $UPE <a href = http://plantgrn.noble.org/psRNATarget/?dowhat=Help#upe><img src = img/question.png width = 13></a>
											";

											$href = '#' . $d;
											#print "$text";
											print "$string<a href='#' title='$mirna alignment details' data-toggle='popover' data-placement='bottom' data-content='$tooltip_text' data-html='true'>$text</a>";

											#print_r($chopped);
										 }
									}
								print "$transcript_part_color\n\n";
								//print "$transcript_part_color\n$bars_part_color\n$lncrna_part_color\n\n";
		
		

								}
	
							print "</pre>";
							
	
					?>
				</div>
				<div id="pairing" class="tab-pane fade">
					<?php	
						
						
						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////
						////////////////////////////////////////////////////////////////////////////////
	
							print "<h4>lncRNA-RNA alignment</h4>";

							print "<span style = 'font-size: 12px;'>";
							print "<br /><span style = 'background-color: #99FF99; padding: 2px; border: 1px solid grey; font-size: 12px;'>ATGC</span> Exon";
							print "<span style = 'padding-left: 20px;'></span><span style = 'background-color: #FFFFCC; padding: 2px; font-size: 12px; border: 1px solid grey;'>atgc</span> Intron";
							print "</span>";
							print "<br />";   
	
							$bars = $alignment_bars;
							$length = 70;
							print "<pre style='border:none; background:none'>";
	
							$lower_flag = 0;
							$upper_flag = 0;
							$prev_lower_flag = 0;
							$prev_upper_flag = 0;
	
							print "\n\n";
							$transcript_sequence = str_replace('-', '', $transcript_sequence);
							for($k = 0; $k < ceil(strlen($transcript_sequence)/$length); $k++)
								{
								$start = $k * $length;
								$end = ($k+1) * $length;
								if($end > strlen($lncrna_sequence))
									{
									$end = strlen($lncrna_sequence);
									}
								$len = $end - $start;
								$lncrna_part = substr($lncrna_sequence, $start, $len);
								$bars_part = substr($bars, $start, $len);
								$transcript_part = substr($transcript_sequence, $start, $len);
		
								$transcript_part_color = '<span>';
								$lncrna_part_color = '<span>';
								$bars_part_color = '<span>';
								for ($n = 0; $n < strlen($transcript_part); $n++)
									{
									$transcript_nt = $transcript_part[$n];
									$bars_nt = $bars_part[$n];
									$lncrna_nt = $lncrna_part[$n];
			
									if(ctype_lower($transcript_nt))
									  {
									  $lower_flag = 1;
									  }
									else
									  {
									  $lower_flag = 0;
									  }
									if (($lower_flag && $prev_lower_flag == 0 && $transcript_nt != '-') || ($n ==0 && $lower_flag))
										{
										$transcript_part_color .= "</span><span style = 'background-color: lightgreen;'>";
										$bars_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
										$lncrna_part_color .= "</span><span style = 'background-color: #FFFFCC;'>";
										}
									if (($lower_flag == 0 && $prev_lower_flag == 1 && $transcript_nt != '-') || ($n ==0 && $lower_flag == 0))
										{
										$transcript_part_color .= "</span><span style = 'background-color: lightgreen;'>";
										$bars_part_color .= "</span><span style = 'background-color: #99FF99;'>";
										$lncrna_part_color .= "</span><span style = 'background-color: #99FF99;'>";
										}
									$transcript_part_color .= $transcript_part[$n];
									$bars_part_color .= $bars_part[$n];
									$lncrna_part_color .= $lncrna_part[$n];
			
									$prev_lower_flag = $lower_flag;
									}
								$transcript_part_color .= '</span>';
								$bars_part_color .= '</span>';
								$lncrna_part_color .= '</span>';
		
								$species_full = $species_array[$species];
								$ensembl_link = "http://plants.ensembl.org/" . $species_full . "/Gene/Summary?;t=" . $transcript_name;
								$cantata_link = "details.php?id=" . $id;
		
								print "$lncrna_part_color\t<a href = $cantata_link>$lncrna_name</a> (lncRNA)\n$bars_part_color\n$transcript_part_color\t<a href = $ensembl_link>$transcript_name</a>\n\n";
		
		

								}
	
							print "</pre>";
	
	
						function generate_id($id)
							{
							$length = strlen($id);
							for($i = 0; $i < (7-$length); $i++)
								{
								$id = '0' . $id;
								}
							$id = 'CNT' . $id;
							return $id;
							}	
					?>
				</div>
			</div>
		</div>
	</div>
    
    <script>
	$(document).ready(function(){
		$('[data-toggle="popover"]').popover();   
	});
	</script>
    
    <!-- Footer -->
    <?php include("footer.php"); ?>
    <!-- End of Footer -->
	
	
	
	

    <!-- jQuery -->
    <!--  <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
