<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<script src="js/jquery.js"></script>
	<script src="js/bootstrap.min.js"></script>
</head>

<body>

    <!-- Navigation -->
    <?php include("nav.php"); ?>
	<!-- End of Navigation -->

    <!-- Page Content -->
    
    <br /><br />
    
    <div class='container'>
    	<div class='row'>
    		<div class="col-lg-12 col-sm-12">
    			<div class='panel panel-success'>
					<div class='panel-heading'>
						<h3 class='panel-title'>lncRNA data</h3>
					</div>
					<div class='panel-body'>
						<table class = 'table table-hover'>
							<thead>
								<tr>
									<th>Species</th> 
									<th>FASTA</th> 
									<th>GTF</th> 
								</tr>
							</thead>
							<tbody>

<?php

					$species_list = array('Amborella_trichopoda', 'Ananas_comosus', 'Arabidopsis_lyrata', 'Arabidopsis_thaliana', 'Brachypodium_distachyon', 'Brassica_napus', 'Brassica_oleracea', 'Brassica_rapa', 'Chenopodium_quinoa', 'Chlamydomonas_reinhardtii', 'Chondrus_crispus', 'Corchorus_capsularis', 'Cucumis_sativus', 'Galdieria_sulphuraria', 'Glycine_max', 'Gossypium_hirsutum', 'Hordeum_vulgare', 'Leersia_perrieri', 'Malus_domestica', 'Manihot_esculenta', 'Medicago_truncatula', 'Musa_acuminata', 'Nicotiana_tabacum', 'Oryza_barthii', 'Oryza_brachyantha', 'Oryza_glaberrima', 'Oryza_meridionalis', 'Oryza_nivara', 'Oryza_punctata', 'Oryza_rufipogon', 'Oryza_sativa_Japonica_Group', 'Physcomitrella_patens', 'Populus_trichocarpa', 'Prunus_persica', 'Selaginella_moellendorffii', 'Setaria_italica', 'Solanum_lycopersicum', 'Solanum_tuberosum', 'Sorghum_bicolor', 'Theobroma_cacao', 'Trifolium_pratense', 'Vitis_vinifera', 'Zea_mays');

					foreach($species_list as $species)
						{
								$sp = str_replace('_', ' ', $species);
								$fasta = 'DOWNLOADS/' . $species . '_lncrnas.fasta';
								$gtf = 'DOWNLOADS/' . $species . '_lncrnas.gtf';
								$fasta_short = $species . '_lncrnas.fasta';
								$gtf_short = $species . '_lncrnas.gtf';
								print "
								<tr>
									<td><i>$sp</i></td>
									<td><a href = $fasta>$fasta_short<a/></td>
									<td><a href = $gtf>$gtf_short<a/></td>
								</tr>";

						}
					?>
					</table>


					</div>
				</div>
    		</div>
    	</div>
    </div>



<br /><br />

    <div class='container'>
    	<div class='row'>
    			<div class='panel panel-success'>
					<div class='panel-heading'>
						<h3 class='panel-title'>Sources of genome sequences</h3>
					</div>
					<div class='panel-body'>


<table border="0" cellpadding="0" cellspacing="0" width="927">
	<colgroup>
		<col>
		<col>
	</colgroup>
	<tbody>
		<tr height="20">
			<td height="20" style="height:20px;width:308px;"><b>Species</b></td>
			<td style="width:619px;"><b>Genome file</b></td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>Amborella_trichopoda.AMTR1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Ananas_comosus/Assembled_chromosomes/seq/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>Arabidopsis_lyrata.v.1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>Arabidopsis_thaliana.TAIR10.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>Brachypodium_distachyon.v1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>Brassica_napus.AST_PRJEB5043_v1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>Brassica_oleracea.v2.1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>Brassica_rapa.IVFCAASv1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Chenopodium_quinoa/CHR_Un/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>Chlamydomonas_reinhardtii.v3.1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chondrus crispus</td>
			<td>Chondrus_crispus.ASM35022v2.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>Corchorus_capsularis.CCACVL1_1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Cucumis_sativus/Assembled_chromosomes/seq/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>Galdieria_sulphuraria.ASM34128v1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>Glycine_max.V1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>Hordeum_vulgare.Hv_IBSC_PGSB_v2.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>Leersia_perrieri.Lperr_V1.4.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Malus_domestica/Assembled_chromosomes/seq/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Manihot_esculenta/Assembled_chromosomes/seq/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>Medicago_truncatula.MedtrA17_4.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>Musa_acuminata.MA1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>Oryza_barthii.O.barthii_v1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza brachyantha</td>
			<td>Oryza_brachyantha.Oryza_brachyantha.v1.4b.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>Oryza_nivara.AWHD00000000.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>Oryza_punctata.AVCL00000000.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>Oryza_rufipogon.OR_W1943.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>ftp://ftp.ncbi.nih.gov/genomes/Oryza_sativa_Japonica_Group/Assembled_chromosomes/seq/</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>Physcomitrella_patens.ASM242v1.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>Populus_trichocarpa.JGI2.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>Prunus_persica.Prupe1_0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Selaginella moellendorffii</td>
			<td>Selaginella_moellendorffii.v1.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>Setaria_italica.JGIv2.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>Solanum_lycopersicum.SL2.50.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>Solanum_tuberosum.SolTub_3.0.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>Sorghum_bicolor.Sorghum_bicolor_v2.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>Theobroma_cacao.Theobroma_cacao_20110822.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>Trifolium_pratense.Trpr.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>Vitis_vinifera.IGGP_12x.dna.toplevel.fa</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>Zea_mays.AGPv4.dna.toplevel.fa</td>
		</tr>
	</tbody>
</table>

				</div>
    		</div>
    	</div>
    </div>





    <br /><br />
    
    <div class='container'>
    	<div class='row'>
    		<div class="col-lg-12 col-sm-12">
    			<div class='panel panel-success'>
					<div class='panel-heading'>
						<h3 class='panel-title'>Sources of genome annotations</h3>
					</div>
					<div class='panel-body'>


<table border="0" cellpadding="0" cellspacing="0" width="679">
	<colgroup>
		<col>
		<col>
	</colgroup>
	<tbody>
		<tr height="20">
			<td height="20" style="height:20px;width:308px;"><b>Species</b></td>
			<td style="width:371px;"><b>Annotations file</b></td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>Amborella_trichopoda.AMTR1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>ref_ASM154086v1_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>Arabidopsis_lyrata.v.1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>Arabidopsis_thaliana.TAIR10.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>Brachypodium_distachyon.v1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>Brassica_napus.AST_PRJEB5043_v1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>Brassica_oleracea.v2.1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>Brassica_rapa.IVFCAASv1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>ref_ASM168347v1_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>Chlamydomonas_reinhardtii.v3.1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chondrus crispus</td>
			<td>Chondrus_crispus.ASM35022v2.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>Corchorus_capsularis.CCACVL1_1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>ref_ASM407v2_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>Galdieria_sulphuraria.ASM34128v1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>Glycine_max.V1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>Hordeum_vulgare.Hv_IBSC_PGSB_v2.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>Leersia_perrieri.Lperr_V1.4.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>ref_MalDomGD1.0_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>ref_Manihot_esculenta_v6_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>Medicago_truncatula.MedtrA17_4.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>Musa_acuminata.MA1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>Oryza_barthii.O.barthii_v1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza brachyantha</td>
			<td>Oryza_brachyantha.Oryza_brachyantha.v1.4b.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>Oryza_nivara.AWHD00000000.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>Oryza_punctata.AVCL00000000.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>Oryza_rufipogon.OR_W1943.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>ref_IRGSP-1.0_top_level.gff3</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>Physcomitrella_patens.ASM242v1.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>Populus_trichocarpa.JGI2.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>Prunus_persica.Prupe1_0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Selaginella moellendorffii</td>
			<td>Selaginella_moellendorffii.v1.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>Setaria_italica.JGIv2.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>Solanum_lycopersicum.SL2.50.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>Solanum_tuberosum.SolTub_3.0.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>Sorghum_bicolor.Sorghum_bicolor_v2.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>Theobroma_cacao.Theobroma_cacao_20110822.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>Trifolium_pratense.Trpr.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>Vitis_vinifera.IGGP_12x.37.gtf</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>Zea_mays.AGPv4.37.gtf</td>
		</tr>
	</tbody>
</table>



					</div>
				</div>
    		</div>
    	</div>
    </div>




    <br /><br />
    
    <div class='container'>
    	<div class='row'>
    		<div class="col-lg-12 col-sm-12">
    			<div class='panel panel-success'>
					<div class='panel-heading'>
						<h3 class='panel-title'>Source databases</h3>
					</div>
					<div class='panel-body'>


<table border="0" cellpadding="0" cellspacing="0" width="488">
	<colgroup>
		<col>
		<col>
	</colgroup>
	<tbody>
		<tr height="20">
			<td height="20" style="height:20px;width:308px;"><b>Species</b></td>
			<td style="width:180px;"><b>Database</b></td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chondrus crispus</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza brachyantha</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>NCBI</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Selaginella moellendorffii</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>Ensembl</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>Ensembl</td>
		</tr>
	</tbody>
</table>



					</div>
				</div>
    		</div>
    	</div>
    </div>





    <br /><br />
    
    <div class='container'>
    	<div class='row'>
    		<div class="col-lg-12 col-sm-12">
    			<div class='panel panel-success'>
					<div class='panel-heading'>
						<h3 class='panel-title'>Sources of RNA-Seq data</h3>
					</div>
					<div class='panel-body'>


<table border="0" cellpadding="0" cellspacing="0" width="577">
	<colgroup>
		<col>
		<col>
	</colgroup>
	<tbody>
		<tr height="20">
			<td height="20" style="height:20px;width:361px;"><b>Species</b></td>
			<td style="width:216px;"><b>Sequence Read Archive run ID</b></td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5932812</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5933152</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR4423523</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5933175</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5932970</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5932905</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5932800</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5933037</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum lycopersicum</td>
			<td>SRR5031855</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR5273771</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR6122525</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156544</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156511</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3310311</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156529</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3207673</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156524</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156522</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Cucumis sativus</td>
			<td>SRR3156508</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293276</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR3309446</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293272</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293275</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293261</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR3309445</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293264</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293277</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293268</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Amborella trichopoda</td>
			<td>SRR5293262</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR3691905</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR3691904</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR3691908</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR5011899</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR5515075</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR6127925</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR3691903</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR3691906</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR1635409</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brachypodium distachyon</td>
			<td>SRR1635430</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR3629832</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR1538491</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR2041050</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR5886936</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR5310831</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR3629822</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR1538829</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR1539558</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR4019432</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Manihot esculenta</td>
			<td>SRR1539560</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR3732343</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR3732348</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR3680391</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR830186</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR830207</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR925840</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR3680387</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Glycine max</td>
			<td>SRR3475904</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>ERR313227</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR5132038</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR2906811</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR2940115</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR1564463</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>ERR313236</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR1660058</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>ERR313237</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR2906848</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Malus domestica</td>
			<td>SRR3036781</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR5572149</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR4300167</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR5974432</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR5572173</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR5572167</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR5572152</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR4300199</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR4300183</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR4300203</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chenopodium quinoa</td>
			<td>SRR4300188</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR787295</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR3350450</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR787291</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR790623</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR3350451</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR790660</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR3350453</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR1707403</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR787292</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Physcomitrella patens</td>
			<td>SRR3350458</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR2089352</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR5040292</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR1867786</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR5046774</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR5046775</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR5046773</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Corchorus capsularis</td>
			<td>SRR5040295</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019764</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019824</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019266</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019883</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019616</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019929</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019621</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019318</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019785</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Populus trichocarpa</td>
			<td>SRR3019588</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1722159</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1722160</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1722161</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1722162</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1171629</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1171630</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza nivara</td>
			<td>SRR1171631</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>ERR1588811</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR1734321</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR5205776</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR1773584</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR5478940</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR3664421</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR3999707</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>ERR1295174</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR4113367</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis thaliana</td>
			<td>SRR2177547</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR2989645</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR4032341</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR2989629</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR3371838</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR2932322</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Solanum tuberosum</td>
			<td>SRR6281220</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chondrus crispus</td>
			<td>ERR2041136</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>SRR5058879</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>SRR5058880</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>ERR1000646</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>ERR1000649</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>ERR1000645</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>SRR5058877</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>SRR402023</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>ERR1000648</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>SRR5058876</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Chlamydomonas reinhardtii</td>
			<td>ERR1000644</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>SRR3536745</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>ERR2003564</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>SRR3536617</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>SRR3536772</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>ERR2003561</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>SRR5748805</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>ERR2003563</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>ERR2003556</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>SRR3536722</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Setaria italica</td>
			<td>ERR2003565</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza brachyantha</td>
			<td>SRR1174794</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR4450939</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR3732000</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877238</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877231</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877244</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877227</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877209</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877228</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Musa acuminata</td>
			<td>SRR5877230</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3189868</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR1238072</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280638</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280774</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280503</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280621</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280851</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR1238066</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR3280502</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica rapa</td>
			<td>SRR6158359</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>DRR036954</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR1564283</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR5925437</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR5925537</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR5925633</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR5925491</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR5925506</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>ERR2061597</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR1985015</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa Japonica Group</td>
			<td>SRR3718442</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR6251246</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312540</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312541</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312542</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312543</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312544</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>SRR5312545</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Trifolium pratense</td>
			<td>ERR351508</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>DRR001371</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>DRR001374</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR3264876</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR3264877</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR3180884</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR3182795</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR1220645</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR1220646</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza rufipogon</td>
			<td>SRR1220647</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR3938636</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR3452726</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>DRR059883</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR5005259</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR3087372</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR3707947</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR2924913</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR2924918</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>SRR1822329</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Sorghum bicolor</td>
			<td>ERR1109876</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR5905533</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR2016207</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR2155562</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR3355338</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR1781543</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR5905541</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR1793860</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR1793856</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR3357562</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica napus</td>
			<td>SRR4242079</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Selaginella moellendorffii</td>
			<td>SRR5499402</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>SRR1171005</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>SRR1171006</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza punctata</td>
			<td>SRR1171007</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>ERR1744570</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR3305232</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR5452122</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR5452103</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR3298414</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR5452100</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR3137027</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR1577845</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Hordeum vulgare</td>
			<td>SRR5452119</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450072</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450073</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450074</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450075</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450076</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450077</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450078</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450079</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Galdieria sulphuraria</td>
			<td>SRR4450080</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR2296884</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR4333195</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR3473270</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR2177446</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR2296894</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR2296910</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR2296886</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR3473214</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Brassica oleracea</td>
			<td>SRR5643652</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR3020584</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR1868052</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR1868063</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR3020589</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR3993767</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR3020599</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR1868044</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR1868059</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR1868042</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Arabidopsis lyrata</td>
			<td>SRR3993764</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR1005276</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR2931146</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR1117255</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR3124595</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR2541230</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR2072479</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR2931502</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza sativa</td>
			<td>SRR2931284</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR2086172</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR2290949</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR1662173</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR5925640</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR2290951</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR2085964</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR5405089</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Prunus persica</td>
			<td>SRR3658831</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR2983907</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR5633635</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR5633648</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR2983912</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR2983888</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR5633613</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR2976829</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Ananas comosus</td>
			<td>SRR2976850</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>SRR1171869</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>SRR1171870</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Leersia perrieri</td>
			<td>SRR1171884</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>ERR2193167</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR1523070</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>ERR2193169</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR3735573</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR949269</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR5217271</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR2060977</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR1523075</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR1979260</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Medicago truncatula</td>
			<td>SRR5217285</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>SRR2558684</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>SRR3085202</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>ERR965605</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>SRR2626637</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>SRR5985056</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>ERR965650</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>SRR1207503</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Zea mays</td>
			<td>ERR1805322</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR747765</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR3217281</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR747762</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR747776</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR3217279</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR747779</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR3217277</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR747774</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR3217282</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Theobroma cacao</td>
			<td>SRR3217319</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1722231</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1722290</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1722291</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1722292</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1170762</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1170742</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Oryza barthii</td>
			<td>SRR1170744</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3069676</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3288880</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3106046</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR5944323</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3046824</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3288867</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3056886</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR2081021</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR5984214</td>
		</tr>
		<tr height="20">
			<td height="20" style="height:20px;">Vitis vinifera</td>
			<td>SRR3938631</td>
		</tr>
	</tbody>
</table>



					</div>
				</div>
    		</div>
    	</div>
    </div>




    
    <!-- End of Page Content -->
    
    <!-- Footer -->
    <?php include("footer.php"); ?>
    <!-- End of Footer -->
	
	
	
	

    <!-- jQuery -->
    <!--  <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
