<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<style type="text/css" class="init">
		th.wrappings, td.wrappings { white-space: nowrap; }
		div.dataTables_wrapper {
			width: 1500px;
			margin: 0 auto;
		}
		.vcenter 
		{
			display: inline-block;
			vertical-align: middle;
			float: none;
		}
	</style>
	
	<script src="js/jquery.js"></script>
	<script src="js/bootstrap.min.js"></script>
	
	
</head>

<body>
    <!-- Navigation -->
    <?php include("nav.php"); ?>
	<!-- End of Navigation -->
	
    <!-- Page Content -->
    
	<?php
		/**
		 * Generate a random string, using a cryptographically secure 
		 * pseudorandom number generator (random_int)
		 * 
		 * For PHP 7, random_int is a PHP core function
		 * For PHP 5.x, depends on https://github.com/paragonie/random_compat
		 * 
		 * @param int $length      How many characters do we want?
		 * @param string $keyspace A string of all possible characters
		 *                         to select from
		 * @return string
		 */
		function random_str($length, $keyspace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')
		{
			$str = '';
			$max = mb_strlen($keyspace, '8bit') - 1;
			for ($i = 0; $i < $length; ++$i) {
				$str .= $keyspace[random_int(0, $max)];
			}
			return $str;
		}
		
		function generateRandomString($length = 10) {
			#$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$charactersLength = strlen($characters);
			$randomString = '';
			for ($i = 0; $i < $length; $i++) {
				$randomString .= $characters[rand(0, $charactersLength - 1)];
			}
			return $randomString;
		}
		
		if(isset($_POST['fasta_name']))
			{$fastaName = $_POST['fasta_name'];}
		else
			{$fastaName = generateRandomString(20) . ".fasta";}
		
		if(isset($_POST['result_name']))
			{$resultName = $_POST['result_name'];}
		else
			{$resultName = generateRandomString(20) . ".html";;}
		
		if (file_exists($resultName))
		{
			$file = file_get_contents("./$resultName", true);
			
			preg_match_all("/CNT(\w+\b)/", $file, $test);
			$accsDict = array();
			foreach($test[0] as $tmp)
				{$accsDict[$tmp] = $tmp;}
			#print_r($accsDict);
			
			foreach($accsDict as $acc)
			{
				$file = str_replace("\n$acc", "\n<a href = 'details.php?idReady=$acc'>$acc", $file);
				$file = str_replace(">$acc", "><a href = 'details.php?idReady=$acc'>$acc", $file);
			}
			
			print "
					<div class='container'>
						<div class='row'>
							<div class='col-sm-12 col-lg-12'>
								$file
							</div>
						</div>
					</div>
				";
			#echo $file . ': ' . filesize($file) . ' bytes<br/>';
			#echo "$file dewewe $resultName";
			#print "
			#			<form action = 'blast.php' method = 'POST' >
			#					<input type = hidden name = 'query_added' value = 1>
			#					<input type = hidden name = 'fasta_name' value = $fastaName>
			#					<input type = hidden name = 'result_name' value = $resultName>
			#					<input type='submit' value='Search' class='btn btn-primary'  />
			#				</form>";
			
			shell_exec("rm $fastaName");
			shell_exec("rm $resultName");
		}
		else
		{
			if(isset($_POST['query_added']))
			{
				$sequence = $_POST['sequence'];
				$query = "$sequence";
				$blastStatus = $_POST['blast_run_made'];
				
				if ($sequence == '')
				{
					print "
							<div class='container'>
								<div class='row'>
									<div class='col-sm-12 col-lg-12 text-center'>
										<br/><br/><h4>No sequence was provided</h4><br/><br/><br/><br/><br/><br/>
									</div>
								</div>
							</div>
						";
				}
				else
				{
				
					#print "$query > blastInputs/test.fasta\nblastall -i blastInputs/test.fasta -d blastDatabases/lncrnas.fasta -p blastn -b 2 -v 2 -e 1e-6 -T T > blastOutputs/test_result.html";
					#print "echo '$query' > blastInputs/test.fasta";
				
					if ($blastStatus != 'Yep')
					{
						$algorithm = $_POST['algorithm'];
						$eVal = $_POST['eVal'];
						$targets = $_POST['targets'];
						shell_exec("echo '$query' > $fastaName");
						if ($algorithm == 'blastn')
							{shell_exec("blastall -i $fastaName -d blastDatabases/lncrnas.fasta -p $algorithm -b $targets -v $targets -e $eVal -T T > $resultName");}
						else
							{shell_exec("megablast -i $fastaName -d blastDatabases/lncrnas.fasta -b $targets -v $targets -e $eVal -T T > $resultName");}
		#				  -v  Number of database sequences to show one-line descriptions for (V) [Integer]
		#					default = 500
		#				  -b  Number of database sequence to show alignments for (B) [Integer]
		#					default = 250
		#				  -e  Expectation value (E) [Real]
   		#					default = 10.0
   		#				  -T  Produce HTML output [T/F]
 		#			        default = F
 						#print "blastall -i $fastaName -d blastDatabases/lncrnas.fasta -p $algorithm -b $targets -v $targets -e $eVal -T T > $resultName";
						#megablast -i M6TDMLKNZEPNGIP8E305.fasta -d blastDatabases/lncrnas.fasta  -b 10 -v 10 -e 1e-6
					}
				
					sleep(5);
				
					if (file_exists($resultName))
					{
						$file = file_get_contents("./$resultName", true);
						
						
						preg_match_all("/CNT(\w+\b)/", $file, $test);
						$accsDict = array();
						foreach($test[0] as $tmp)
							{$accsDict[$tmp] = $tmp;}
						#print_r($accsDict);
			
						foreach($accsDict as $acc)
						{
							$file = str_replace("\n$acc", "\n<a href = 'details.php?idReady=$acc'>$acc", $file);
							$file = str_replace(">$acc", "><a href = 'details.php?idReady=$acc'>$acc", $file);
						}
						
						#str_replace("world","Peter","Hello world!");
						
						print "
							<div class='container'>
								<div class='row'>
									<div class='col-sm-12 col-lg-12'>
										$file
									</div>
								</div>
							</div>
						";
						
						#echo "$file dewewe $resultName";
				
						shell_exec("rm $fastaName");
						shell_exec("rm $resultName");
						
						#$filename = '/path/to/foo.txt';
					}
					else
					{
						print "
							<h4>BLAST is still running, please refresh the page</h4><br/><br/>
						
							<form action = 'blast.php' method = 'POST' >
								<input type = hidden name = 'query_added' value = 1>
								<input type = hidden name = 'fasta_name' value = $fastaName>
								<input type = hidden name = 'result_name' value = $resultName>
								<input type = hidden name = 'blast_run_made' value = 'Yep'>
								<input type='submit' value='Refresh page' class='btn btn-primary'  />
							</form>";
					
					}
				}
				
			}
			else
			{
				print "
				<div class='container'>
					<div class='row'>
						<div class='col-sm-12 col-lg-9'>
							<b>Enter a nucleotide sequence in <a href = 'https://en.wikipedia.org/wiki/FASTA_format'>FASTA</a> format:</b><br/>
							<form action = 'blast.php' method = 'POST' >
								<textarea name = 'sequence' class='form-control' rows='9' value = ''></textarea>
								<input type = hidden name = 'query_added' value = 1>
								<input type = hidden name = 'fasta_name' value = $fastaName>
								<input type = hidden name = 'result_name' value = $resultName>
								<br/>
								<table class='table'>
									<tr>
										<th>Optimize for:</th>
										<td><select name = 'algorithm' class='form-control'>
												<option value = 'blastn'>BLASTN</option>
												<option value = 'megablast'>MEGABLAST</option>
											</select>
										</td>
									</tr>
									<tr>
										<th>Expectation value:</th>
										<td><select name = 'eVal' class='form-control'>
												<option value = '1e-20'>1e-20</option>
												<option value = '1e-10'>1e-10</option>
												<option value = '1e-5'>1e-5</option>
												<option value = '0.1'>0.1</option>
												<option value = '1'>1</option>
											</select>
										</td>
									</tr>
									<tr>
										<th>Max. target sequences:</th>
										<td><select name = 'targets' class='form-control'>
												<option value = '10'>10</option>
												<option value = '100'>100</option>
												<option value = '1000'>1000</option>
											</select>
										</td>
									</tr>
								</table>
								<br/>
								<input type='submit' value='BLAST' class='btn btn-primary'  />
							</form>
						</div>
					</div>
                    <br /><br />
                    The remaining search settings are left default, as specified in the corresponding help pages: <a href = blastall>BLASTN help page</a> and <a href = megablast>MEGABLAST help page</a>.
				</div>
				</div>
				";
			}
		}
	?>
    <!-- Footer -->
    <?php include("footer.php"); ?>
    <!-- End of Footer -->
	
	<?php
#	preg_match_all("/(?!\b)(t\w+\b)/", "<b>example: </b><div align=left>this is a test</div>", $out, PREG_PATTERN_ORDER);
#echo $out[0][0] . ", " . $out[0][1] . "\n";
#echo $out[1][0] . ", " . $out[1][1] . "\n";
#print_r($out);
#preg_match_all("/CNT(\w+\b)/", "Call CNT0004050 or CNT0005980", $test);
#$accsDict = array();
#foreach($test[0] as $tmp)
#	{$accsDict[$tmp] = $tmp;}
#print_r($accsDict);
	#{print "$tmp<br/>";}
      #  print_r($phones);
	?>

    <!-- jQuery -->
    <!--  <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
