<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/shCore.css"> -->
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<style type="text/css" class="init">

	th.wrappings, td.wrappings { white-space: nowrap; }
	div.dataTables_wrapper {
		width: 1300px;
		margin: 0 auto;
	}

	</style>
</head>

<body>

    <!-- Navigation -->
    <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
        <div class="container">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="#">
                    <img src="img/CANTATA_Logo.png" alt="">
                </a>
            </div>
            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <ul class="nav navbar-nav">
                    <li>
                        <a href="index.php">Home</a>
                    </li>
                    <li class="dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Search <span class="caret"></span></a>
						<ul class="dropdown-menu">
							<li class="dropdown-header">Select the organism</li>
							<li><a href="search.php?species=amborella">Amborella trichopoda</a></li>
							<li><a href="search.php?species=arabidopsis">Arabidopsis thaliana</a></li>
							<li><a href="search.php?species=chlamydomonas">Chlamydomonas reinhardtii</a></li>
							<li><a href="search.php?species=glycine">Glycine max</a></li>
							<li><a href="search.php?species=oryza">Oryza sativa</a></li>
							<li><a href="search.php?species=physcomitrella">Physcomitrella patens</a></li>
							<li><a href="search.php?species=selaginella">Selaginella moellendorffii</a></li>
							<li><a href="search.php?species=potato">Solanum tuberosum</a></li>
							<li><a href="search.php?species=vitis">Vitis vinifera</a></li>
							<li><a href="search.php?species=zea">Zea mays</a></li>
							<li role="separator" class="divider"></li>
							<li class="dropdown-header">Nav header</li>
							<li><a href="statistics.php">Basic statistics of the data</a></li>
						</ul>
					</li>
                    <li>
                        <a href="download.php">Download</a>
                    </li>
                    <li>
                        <a href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
            <!-- /.navbar-collapse -->
        </div>
        <!-- /.container -->
    </nav>

    <!-- Page Content -->
    
    <?php
		include("DatabaseConnect.php");
		
		$species_list = array('arabidopsis' => 'A. thaliana', 'amborella' => 'A. trichopoda', 'glycine' => 'G. max', 'oryza' => 'O. sativa', 'zea' => 'Z. mays', 'vitis' => 'V. vinifera', 'potato' => 'S. tuberosum', 'selaginella' => 'S. moellendorffii', 'physcomitrella' => 'P. patens', 'chlamydomonas' => 'C. reinhardtii');
		$species_list_full = array('arabidopsis' => 'Arabidopsis thaliana', 'amborella' => 'Amborella trichopoda', 'glycine' => 'Glycine max', 'oryza' => 'Oryza sativa', 'zea' => 'Zea mays', 'vitis' => 'Vitis vinifera', 'potato' => 'Solanum tuberosum', 'selaginella' => 'Selaginella moellendorffii', 'physcomitrella' => 'Physcomitrella patens', 'chlamydomonas' => 'Chlamydomonas reinhardtii');
	
		if(isset($_POST['id_selected']))
			{
			$id_selected = $_POST['id_selected'];
			$id_selected_for_display = $id_selected;
			$id_selected = raw_id($id_selected);
			}
		elseif(isset($_GET['id_selected']))
			{
			$id_selected = $_GET['id_selected'];
			$id_selected_for_display = $id_selected;
			}
		else
			{
			$id_selected = '';
			$id_selected_for_display = '';
			}
	
		if($id_selected)
			{
			$query_species = "select species from lncrnas where id = '$id_selected';";
			if (!($result_species = @ mysql_query($query_species)))
				die ("Could not execute mySQL query: species");
			$this_species = mysql_result($result_species,0,"species"); 
			}	
		else
			{
			$this_species = '';
			}
				
		if(!$this_species)
			{
			if(isset($_GET['species']))
				{
				$species = $_GET['species'];
				}
			elseif(isset($_POST['species']) && !(isset($_GET['species'])))
				{
				$species = $_POST['species'];
				}
			else
				{
				$species = 'arabidopsis';
				}
			}
		else
			{
			$species = $this_species;
			}



	?>
    
    
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
            	<?php 
					if(isset($_POST['id_selected']))
						{
						$id_selected = $_POST['id_selected'];
						$id_selected_for_display = $id_selected;
						$id_selected = raw_id($id_selected);
						}
					elseif(isset($_GET['id_selected']))
						{
						$id_selected = $_GET['id_selected'];
						$id_selected_for_display = $id_selected;
						}
					else
						{
						$id_selected = '';
						$id_selected_for_display = '';
						}
	
					if(isset($_POST['cpc_status_selected']))
						{
						$cpc_status_selected = $_POST['cpc_status_selected'];
						}
					elseif(isset($_GET['cpc_status_selected']))
						{
						$cpc_status_selected = $_GET['cpc_status_selected'];
						}
					else
						{
						$cpc_status_selected = '';
						}

					if(isset($_POST['max_peptide_length_selected']))
						{
						$max_peptide_length_selected = $_POST['max_peptide_length_selected'];
						}
					elseif(isset($_GET['max_peptide_length_selected']))
						{
						$max_peptide_length_selected = $_GET['max_peptide_length_selected'];
						}
					else
						{
						$max_peptide_length_selected = 1000000;
						}

					if(isset($_POST['max_expression_selected']))
						{
						$max_expression_selected = $_POST['max_expression_selected'];
						}
					elseif(isset($_GET['max_expression_selected']))
						{
						$max_expression_selected = $_GET['max_expression_selected'];
						}
					else
						{
						$max_expression_selected = -1;
						}
	
					if(isset($_POST['event_selected']))
						{
						$event_selected = $_POST['event_selected'];
						}
					elseif(isset($_GET['event_selected']))
						{
						$event_selected = $_GET['event_selected'];
						}
					else
						{
						$event_selected = '';
						}
					if(isset($_POST['biotype_selected']))
						{
						$biotype_selected = $_POST['biotype_selected'];
						}
					elseif(isset($_GET['biotype_selected']))
						{
						$biotype_selected = $_GET['biotype_selected'];
						}
					else
						{
						$biotype_selected = 'protein_coding';
						}
					if(isset($_POST['order']))
						{
						$order = $_POST['order'];
						}
					elseif(isset($_GET['order']))
						{
						$order = $_GET['order'];
						}
					else
						{
						$order = 'id DESC';
						}

					if(isset($_GET['page']))
						{
						$page = $_GET['page'];
						}
					elseif(isset($_POST['page']) && !(isset($_GET['page'])))
						{
						$page = $_POST['page'];
						}
					else
						{
						$page = 1;
						}
            
            		print "
						<br />
						<form action = 'search.php' method = 'POST' >
							<b>SEARCH OPTIONS</b><br />
							<div class='table-responsive'>
								<table class = 'table table-bordered table-striped'>
									<tr> 
										<td>lncRNA id <span style = 'font-size: 10px;'>(e.g. <span style = 'font-family: courier;'>CNT0002982</span> in <i>G. max</i>)</span></td> 
										<td>CPC status</td> 
										<td>Max. peptide length</td> 
										<td>Max. expression</td> 
										<td>Potential function</td> 
										<td>Order by</td> 
									 </tr>
									 <tr>
										<td>
											<input type = hidden name = 'page' value = $page>
											<input type = hidden name = 'species' value = $species>
											<input type = 'text' name = 'id_selected' value = ''>
										</td> 
										<td>
											<select name = 'cpc_status_selected'>
											   <OPTION value = ''>Select
											   <OPTION value = 'noncoding'>noncoding
											   <OPTION value = 'coding'>coding
											</select>
										</td>
										<td>
											<select name = 'max_peptide_length_selected'>
											   <OPTION value = '1000000'>Select
											   <OPTION value = '30'><30 AA
											   <OPTION value = '50'><50 AA
											   <OPTION value = '100'><100 AA
											   <OPTION value = '200'><200 AA
											</select>
										</td>
										<td>
											<select name = 'max_expression_selected'>
											   <OPTION value = '-1'>Select
											   <OPTION value = '0'>>0 RPKM
											   <OPTION value = '1'>>1 RPKM
											   <OPTION value = '10'>>10 RPKM
											   <OPTION value = '100'>>100 RPKM
											</select>
										</td>
										<td>
											<select name = 'event_selected'>
											   <OPTION value = ''>Select
											   <OPTION value = 'mirna'>miRNA-associated
											   <OPTION value = 'splicing'>Splicing regulation
											</select>
										</td>
										<td>
											<select name = 'order'>
											   <OPTION value = 'id DESC'>lncRNA id (descending)
											   <OPTION value = 'uniprot_evalue DESC'>Swiss-Prot E-value (descending)
											   <OPTION value = 'max_expression DESC'>Expression (descending)
											   <OPTION value = 'max_peptide length ASC'>Peptide length (ascending)
											</select>
										</td>
									</tr>
								</table>
							</div>
							<input type='submit' value='Search' class = 'submit'  />

						</form> <br />
							  ";

					if($id_selected)
						{
						print "<b>lncRNA</b>: $id_selected_for_display<br />";
						}
					if($cpc_status_selected)
						{
						print "<b>CPC status</b>: $cpc_status_selected<br />";
						}
					if($max_peptide_length_selected < 1000000)
						{
						print "<b>Max. peptide length</b>: < $max_peptide_length_selected AA<br />";
						}
					if($max_expression_selected > -1)
						{
						print "<b>Max. expression</b>: > $max_expression_selected RPKM<br />";
						}
					if($event_selected)
						{
						print "<b>Evemt</b>: $event_selected<br />";
						}
					if($order)
						{
						print "<b>Order by</b>: $order<br />";
						}
					print "<hr />";
    
    print "</div></div></div>";
    print "<div class='container'>
    			<div class='dataTables_wrapper'>
    				<section>";
    				
            		////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					if($id_selected)
						{
						$query = "select * from lncrnas where species = '$species' and id = '$id_selected' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						}
					else
						{
						$query = "select * from lncrnas where species = '$species' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						}
					 //   print $query;
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////


					if (!($result = @ mysql_query($query)))
						die ("Could not execute mySQL query");

					$number = mysql_numrows($result);

					//$number = 100000;
					$records_per_page = 50;
					$species_full = $species_list_full[$species];
					print "<br />Found <span style = 'font-size: 16px; font-weight: bold;'>$number</span> records in <i>$species_full</i>";

					if($number > $records_per_page)
						{
						print "<br /><br />Go to page:<br />";
						}

					$start = ($page - 1) * $records_per_page;
					$end = $start + $records_per_page;     
					if($end > $number)
					  {
					  $end = $number;
					  }  

					$nr_of_pages = ceil($number / $records_per_page);

					for($k = 1; $k < $nr_of_pages; $k++)
					{
					if($k <= 10)
						{
						print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
						}
					if ($k > 10 and $k <= 100)
						{
						if($k%10 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					if ($k > 100 and $k <= 1000)
						{
						if($k%100 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					if ($k > 1000 and $k <= 10000)
						{
						if($k%1000 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					}

					$next = $page + 1;
					$prev = $page - 1;

					print "<br /><br />";
					if($page > 1)
					{
					print "<a href = 'search.php?page=1&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> first </a> ";
					}
					if($prev > 0)
						{
						print "<a href = 'search.php?page=$prev&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> prev </a>";
						}
					if($number)
						{
						print "<span style = 'border: 1px solid grey; padding: 3px; margin: 3px;'> page $page </span>";
						}
					if($next <= $nr_of_pages)
						{
						print " <a href = 'search.php?page=$next&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> next </a>";
						}
					if($page < $nr_of_pages)
						{
						print " <a href = 'search.php?page=$nr_of_pages&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> last </a>";
						}   
 
					print "<br /><br />";
	
					if($number)
						{
						print "
							<div class='table-responsive'>
								<table class='table table-bordered table-hover table-striped'  style='width: 1000 important!;'>
									<thead>
										<tr>
											<th>ID</td> 
											<th>Species</td> 
											<th>Location</td> 
											<th class='wrappings'>CPC status (score)</td> 
											<th class='wrappings'>Swiss-Prot best hit</td> 
											<th class='wrappings'>Max. peptide length</td> 
											<th class='wrappings'>Max. expression</td> 
											<th class='wrappings'>Potential function</td> 
											<th>Details</td>
										</tr>
									</thead>
									<tbody>
							  ";
						
						
						for($i=$start; $i<$end; $i++)
							{
							$j = $i + 1;
							$id = mysql_result($result,$i,"id");  
							$this_species = mysql_result($result,$i,"species");  
							$transcript = mysql_result($result,$i,"transcript");  
							$gene = mysql_result($result,$i,"gene");  
							$cnci_status = mysql_result($result,$i,"cnci_status");  
							$cpc_status = mysql_result($result,$i,"cpc_status");  
							$cpc_score = mysql_result($result,$i,"cpc_score");  
							$blast_noncode_arabidopsis = mysql_result($result,$i,"blast_noncode_arabidopsis");  
							$blast_pnrd_populus = mysql_result($result,$i,"blast_pnrd_populus");  
							$blast_pnrd_oryza = mysql_result($result,$i,"blast_pnrd_oryza");  
							$blast_pnrd_zea = mysql_result($result,$i,"blast_pnrd_zea");  
							$blast_uniprot = mysql_result($result,$i,"blast_uniprot");  
							$reciprocal = mysql_result($result,$i,"reciprocal");  
							$predicted_hits = mysql_result($result,$i,"predicted_hits");  
							$max_peptide_length = mysql_result($result,$i,"max_peptide_length");  
	
							if($max_peptide_length == 0)
								{
								$max_peptide_length = '-';
								}
	
							$uniprot_hit = explode('*', $blast_uniprot);
							$uniprot_hit = $uniprot_hit[0];
							$uniprot_id = explode('|', $uniprot_hit);
							$uniprot_id = $uniprot_id[1];
							$uniprot_link = "http://www.uniprot.org/uniprot/" . $uniprot_id;

	
							$uniprot_evalue = mysql_result($result,$i,"uniprot_evalue");  
							$events_string = mysql_result($result,$i,"events_string");  
							$events_string = str_replace('miRNA', 'miRNA-associated', $events_string);
							$events_string = str_replace('splicing', 'splicing regulation', $events_string);
							$chr = mysql_result($result,$i,"chr");  
							$this_start = mysql_result($result,$i,"start");  
							$this_end = mysql_result($result,$i,"end");  
							$strand = mysql_result($result,$i,"strand");  
							$max_expression = mysql_result($result,$i,"max_expression");  
	
							$species_full = $species_list_full[$species];
							$species_full = str_replace(' ', '_', $species_full);
							$ensembl_link = "http://plants.ensembl.org/" . $species_full . "/Location/View?db=core;r=" . $chr . ':' . $this_start . '-' . $this_end;
	
	
	
	
							$this_species = $species_list[$this_species];
	
							$display_id = generate_id($id);
	
							$species_full_space = str_replace('_', ' ', $species_full);

							print "
								<tr>
									<td>$display_id</td>
									<td nowrap><i>$this_species</i></td>
									<td nowrap><a href = $ensembl_link title = 'View the region at Ensembl Plants'>$chr:$this_start-$this_end ($strand)</a></td>
									<td>$cpc_status ($cpc_score)</td>";
									if($uniprot_evalue > -1)
										{
										print "<td>$uniprot_evalue (<a href = $uniprot_link>$uniprot_hit</a>)</td>";
										}
									else
										{
										print "<td>-</td>";                
										}
									print "
									<td>$max_peptide_length</td>
									<td>$max_expression</td>
									<td>$events_string</td>
									<td><a href = details.php?id=$id&species=$species>Details</a></td>
								</tr>";
							}

			
						print "</tbody></table></div>";   
						}


					function generate_id($id)
						{
						$length = strlen($id);
						for($i = 0; $i < (7-$length); $i++)
							{
							$id = '0' . $id;
							}
						$id = 'CNT' . $id;
						return $id;
						}

					function raw_id($id)
						{
						$id = str_replace('CNT', '', $id);
						$id = intval($id);
						return $id;
						}    
	
					if($number < 10)
						{
						print "<br /><br /><br /><br /><br /><br /><br /><br /><br />";
						}
 
            	
            	
            	?>
            
            
                
            </section>
         </div>
    </div>
    
    <br><br><br><br><br><br><br><br><br><br>
    
    <div class='container'>
    	<br><br><hr>
    	<footer>
			<div class="row">
				<div class="col-lg-12">
				<p style="color: grey; text-align:center;">Copyright &copy; CANTATAdb 2015</p>
				</div>
			</div>
    	</footer>
    </div>
    <!-- /.container -->
	
	
    <!-- jQuery -->
    <script src="js/jquery.js"></script>

    <!-- Bootstrap Core JavaScript -->
    <script src="js/bootstrap.min.js"></script>

</body>

</html>
