<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>CANTATAdb - search</title>

    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="css/logo-nav.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
	
	<link rel="stylesheet" type="text/css" href="tables/jquery.dataTables.css">
	<link rel="stylesheet" type="text/css" href="tables/shCore.css">
	<!-- <link rel="stylesheet" type="text/css" href="tables/demo.css"> -->
	<style type="text/css" class="init">

	th, td { white-space: nowrap; }
	div.dataTables_wrapper {
		width: 800px;
		margin: 0 auto;
	}

	</style>
	<script type="text/javascript" language="javascript" src="tables/jquery.js"></script>
	<script type="text/javascript" language="javascript" src="tables/jquery.dataTables.js"></script>
	<script type="text/javascript" language="javascript" src="tables/shCore.js"></script>
	<script type="text/javascript" language="javascript" src="tables/demo.js"></script>
	<script type="text/javascript" language="javascript" class="init">

	$(document).ready(function() {
	$('#example').dataTable( {
		"scrollX": true
	} );
} );

	</script>
	
</head>

<body>

    <!-- Navigation -->
    <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
        <div class="container">
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="#">
                    <img src="img/CANTATA_Logo.png" alt="">
                </a>
            </div>
            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <ul class="nav navbar-nav">
                    <li>
                        <a href="index.php">Home</a>
                    </li>
                    <li class="dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Search <span class="caret"></span></a>
						<ul class="dropdown-menu">
							<li class="dropdown-header">Select the organism</li>
							<li><a href="search.php?species=amborella">Amborella trichopoda</a></li>
							<li><a href="search.php?species=arabidopsis">Arabidopsis thaliana</a></li>
							<li><a href="search.php?species=chlamydomonas">Chlamydomonas reinhardtii</a></li>
							<li><a href="search.php?species=glycine">Glycine max</a></li>
							<li><a href="search.php?species=oryza">Oryza sativa</a></li>
							<li><a href="search.php?species=physcomitrella">Physcomitrella patens</a></li>
							<li><a href="search.php?species=selaginella">Selaginella moellendorffii</a></li>
							<li><a href="search.php?species=potato">Solanum tuberosum</a></li>
							<li><a href="search.php?species=vitis">Vitis vinifera</a></li>
							<li><a href="search.php?species=zea">Zea mays</a></li>
							<li role="separator" class="divider"></li>
							<li class="dropdown-header">Nav header</li>
							<li><a href="statistics.php">Basic statistics of the data</a></li>
						</ul>
					</li>
                    <li>
                        <a href="download.php">Download</a>
                    </li>
                    <li>
                        <a href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
            <!-- /.navbar-collapse -->
        </div>
        <!-- /.container -->
    </nav>

    <!-- Page Content -->
    
    <?php
		include("DatabaseConnect.php");
		
		$species_list = array('arabidopsis' => 'A. thaliana', 'amborella' => 'A. trichopoda', 'glycine' => 'G. max', 'oryza' => 'O. sativa', 'zea' => 'Z. mays', 'vitis' => 'V. vinifera', 'potato' => 'S. tuberosum', 'selaginella' => 'S. moellendorffii', 'physcomitrella' => 'P. patens', 'chlamydomonas' => 'C. reinhardtii');
		$species_list_full = array('arabidopsis' => 'Arabidopsis thaliana', 'amborella' => 'Amborella trichopoda', 'glycine' => 'Glycine max', 'oryza' => 'Oryza sativa', 'zea' => 'Zea mays', 'vitis' => 'Vitis vinifera', 'potato' => 'Solanum tuberosum', 'selaginella' => 'Selaginella moellendorffii', 'physcomitrella' => 'Physcomitrella patens', 'chlamydomonas' => 'Chlamydomonas reinhardtii');
	
		if(isset($_POST['id_selected']))
			{
			$id_selected = $_POST['id_selected'];
			$id_selected_for_display = $id_selected;
			$id_selected = raw_id($id_selected);
			}
		elseif(isset($_GET['id_selected']))
			{
			$id_selected = $_GET['id_selected'];
			$id_selected_for_display = $id_selected;
			}
		else
			{
			$id_selected = '';
			$id_selected_for_display = '';
			}
	
		if($id_selected)
			{
			$query_species = "select species from lncrnas where id = '$id_selected';";
			if (!($result_species = @ mysql_query($query_species)))
				die ("Could not execute mySQL query: species");
			$this_species = mysql_result($result_species,0,"species"); 
			}	
		else
			{
			$this_species = '';
			}
				
		if(!$this_species)
			{
			if(isset($_GET['species']))
				{
				$species = $_GET['species'];
				}
			elseif(isset($_POST['species']) && !(isset($_GET['species'])))
				{
				$species = $_POST['species'];
				}
			else
				{
				$species = 'arabidopsis';
				}
			}
		else
			{
			$species = $this_species;
			}



	?>
    
    
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
            	<?php 
					if(isset($_POST['id_selected']))
						{
						$id_selected = $_POST['id_selected'];
						$id_selected_for_display = $id_selected;
						$id_selected = raw_id($id_selected);
						}
					elseif(isset($_GET['id_selected']))
						{
						$id_selected = $_GET['id_selected'];
						$id_selected_for_display = $id_selected;
						}
					else
						{
						$id_selected = '';
						$id_selected_for_display = '';
						}
	
					if(isset($_POST['cpc_status_selected']))
						{
						$cpc_status_selected = $_POST['cpc_status_selected'];
						}
					elseif(isset($_GET['cpc_status_selected']))
						{
						$cpc_status_selected = $_GET['cpc_status_selected'];
						}
					else
						{
						$cpc_status_selected = '';
						}

					if(isset($_POST['max_peptide_length_selected']))
						{
						$max_peptide_length_selected = $_POST['max_peptide_length_selected'];
						}
					elseif(isset($_GET['max_peptide_length_selected']))
						{
						$max_peptide_length_selected = $_GET['max_peptide_length_selected'];
						}
					else
						{
						$max_peptide_length_selected = 1000000;
						}

					if(isset($_POST['max_expression_selected']))
						{
						$max_expression_selected = $_POST['max_expression_selected'];
						}
					elseif(isset($_GET['max_expression_selected']))
						{
						$max_expression_selected = $_GET['max_expression_selected'];
						}
					else
						{
						$max_expression_selected = -1;
						}
	
					if(isset($_POST['event_selected']))
						{
						$event_selected = $_POST['event_selected'];
						}
					elseif(isset($_GET['event_selected']))
						{
						$event_selected = $_GET['event_selected'];
						}
					else
						{
						$event_selected = '';
						}
					if(isset($_POST['biotype_selected']))
						{
						$biotype_selected = $_POST['biotype_selected'];
						}
					elseif(isset($_GET['biotype_selected']))
						{
						$biotype_selected = $_GET['biotype_selected'];
						}
					else
						{
						$biotype_selected = 'protein_coding';
						}
					if(isset($_POST['order']))
						{
						$order = $_POST['order'];
						}
					elseif(isset($_GET['order']))
						{
						$order = $_GET['order'];
						}
					else
						{
						$order = 'id DESC';
						}

					if(isset($_GET['page']))
						{
						$page = $_GET['page'];
						}
					elseif(isset($_POST['page']) && !(isset($_GET['page'])))
						{
						$page = $_POST['page'];
						}
					else
						{
						$page = 1;
						}
            
            		print "
						<br />
						<form action = 'search.php' method = 'POST' >
							<b>SEARCH OPTIONS</b><br />
							<div class='table-responsive'>
								<table class = 'table table-bordered table-striped'>
									<tr> 
										<td>lncRNA id <span style = 'font-size: 10px;'>(e.g. <span style = 'font-family: courier;'>CNT0002982</span> in <i>G. max</i>)</span></td> 
										<td>CPC status</td> 
										<td>Max. peptide length</td> 
										<td>Max. expression</td> 
										<td>Potential function</td> 
										<td>Order by</td> 
									 </tr>
									 <tr>
										<td>
											<input type = hidden name = 'page' value = $page>
											<input type = hidden name = 'species' value = $species>
											<input type = 'text' name = 'id_selected' value = ''>
										</td> 
										<td>
											<select name = 'cpc_status_selected'>
											   <OPTION value = ''>Select
											   <OPTION value = 'noncoding'>noncoding
											   <OPTION value = 'coding'>coding
											</select>
										</td>
										<td>
											<select name = 'max_peptide_length_selected'>
											   <OPTION value = '1000000'>Select
											   <OPTION value = '30'><30 AA
											   <OPTION value = '50'><50 AA
											   <OPTION value = '100'><100 AA
											   <OPTION value = '200'><200 AA
											</select>
										</td>
										<td>
											<select name = 'max_expression_selected'>
											   <OPTION value = '-1'>Select
											   <OPTION value = '0'>>0 RPKM
											   <OPTION value = '1'>>1 RPKM
											   <OPTION value = '10'>>10 RPKM
											   <OPTION value = '100'>>100 RPKM
											</select>
										</td>
										<td>
											<select name = 'event_selected'>
											   <OPTION value = ''>Select
											   <OPTION value = 'mirna'>miRNA-associated
											   <OPTION value = 'splicing'>Splicing regulation
											</select>
										</td>
										<td>
											<select name = 'order'>
											   <OPTION value = 'id DESC'>lncRNA id (descending)
											   <OPTION value = 'uniprot_evalue DESC'>Swiss-Prot E-value (descending)
											   <OPTION value = 'max_expression DESC'>Expression (descending)
											   <OPTION value = 'max_peptide length ASC'>Peptide length (ascending)
											</select>
										</td>
									</tr>
								</table>
							</div>
							<input type='submit' value='Search' class = 'submit'  />

						</form> <br />
							  ";

					if($id_selected)
						{
						print "<b>lncRNA</b>: $id_selected_for_display<br />";
						}
					if($cpc_status_selected)
						{
						print "<b>CPC status</b>: $cpc_status_selected<br />";
						}
					if($max_peptide_length_selected < 1000000)
						{
						print "<b>Max. peptide length</b>: < $max_peptide_length_selected AA<br />";
						}
					if($max_expression_selected > -1)
						{
						print "<b>Max. expression</b>: > $max_expression_selected RPKM<br />";
						}
					if($event_selected)
						{
						print "<b>Evemt</b>: $event_selected<br />";
						}
					if($order)
						{
						print "<b>Order by</b>: $order<br />";
						}
					print "<hr />";
            	
            		////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					if($id_selected)
						{
						$query = "select * from lncrnas where species = '$species' and id = '$id_selected' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						}
					else
						{
						$query = "select * from lncrnas where species = '$species' and cpc_status like '$cpc_status_selected%' and max_peptide_length < '$max_peptide_length_selected' and max_expression > '$max_expression_selected' and events_string like '%$event_selected%' order by $order;";
						}
					 //   print $query;
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////
					////////////////////////////////////////////////////////////////////////////////


					if (!($result = @ mysql_query($query)))
						die ("Could not execute mySQL query");

					$number = mysql_numrows($result);

					//$number = 100000;
					$records_per_page = 50;
					$species_full = $species_list_full[$species];
					print "<br />Found <span style = 'font-size: 16px; font-weight: bold;'>$number</span> records in <i>$species_full</i>";

					if($number > $records_per_page)
						{
						print "<br /><br />Go to page:<br />";
						}

					$start = ($page - 1) * $records_per_page;
					$end = $start + $records_per_page;     
					if($end > $number)
					  {
					  $end = $number;
					  }  

					$nr_of_pages = ceil($number / $records_per_page);

					for($k = 1; $k < $nr_of_pages; $k++)
					{
					if($k <= 10)
						{
						print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
						}
					if ($k > 10 and $k <= 100)
						{
						if($k%10 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					if ($k > 100 and $k <= 1000)
						{
						if($k%100 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					if ($k > 1000 and $k <= 10000)
						{
						if($k%1000 == 0)
							{
							print "<a href = 'search.php?page=$k&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'>$k </a>";
							}
						}
					}

					$next = $page + 1;
					$prev = $page - 1;

					print "<br /><br />";
					if($page > 1)
					{
					print "<a href = 'search.php?page=1&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> first </a> ";
					}
					if($prev > 0)
						{
						print "<a href = 'search.php?page=$prev&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> prev </a>";
						}
					if($number)
						{
						print "<span style = 'border: 1px solid grey; padding: 3px; margin: 3px;'> page $page </span>";
						}
					if($next <= $nr_of_pages)
						{
						print " <a href = 'search.php?page=$next&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> next </a>";
						}
					if($page < $nr_of_pages)
					{
					print " <a href = 'search.php?page=$nr_of_pages&order=$order&species=$species&id_selected=$id_selected&event_selected=$event_selected&cpc_status_selected=$cpc_status_selected&max_peptide_length_selected=$max_peptide_length_selected&max_expression_selected=$max_expression_selected&order=$order'> last </a>";
					 }   
 
					print "<br /><br />";
	
					if($number)
						{
						print "
							<div class='table-responsive'>
								<table class='table table-bordered table-hover table-striped'  style='width: 1000 important!;'>
									<thead>
										<tr>
											<td>ID</td> 
											<td>Species</td> 
											<td>Location</td> 
											<td>CPC status (score)</td> 
											<td>Swiss-Prot best hit</td> 
											<td>Max. peptide length</td> 
											<td>Max. expression</td> 
											<td>Potential function</td> 
											<td>Details</td>
										<tr>
									</thead>
									<tbody>
							  ";
						
						
						for($i=$start; $i<$end; $i++)
							{
							$j = $i + 1;
							$id = mysql_result($result,$i,"id");  
							$this_species = mysql_result($result,$i,"species");  
							$transcript = mysql_result($result,$i,"transcript");  
							$gene = mysql_result($result,$i,"gene");  
							$cnci_status = mysql_result($result,$i,"cnci_status");  
							$cpc_status = mysql_result($result,$i,"cpc_status");  
							$cpc_score = mysql_result($result,$i,"cpc_score");  
							$blast_noncode_arabidopsis = mysql_result($result,$i,"blast_noncode_arabidopsis");  
							$blast_pnrd_populus = mysql_result($result,$i,"blast_pnrd_populus");  
							$blast_pnrd_oryza = mysql_result($result,$i,"blast_pnrd_oryza");  
							$blast_pnrd_zea = mysql_result($result,$i,"blast_pnrd_zea");  
							$blast_uniprot = mysql_result($result,$i,"blast_uniprot");  
							$reciprocal = mysql_result($result,$i,"reciprocal");  
							$predicted_hits = mysql_result($result,$i,"predicted_hits");  
							$max_peptide_length = mysql_result($result,$i,"max_peptide_length");  
	
							if($max_peptide_length == 0)
								{
								$max_peptide_length = '-';
								}
	
							$uniprot_hit = explode('*', $blast_uniprot);
							$uniprot_hit = $uniprot_hit[0];
							$uniprot_id = explode('|', $uniprot_hit);
							$uniprot_id = $uniprot_id[1];
							$uniprot_link = "http://www.uniprot.org/uniprot/" . $uniprot_id;

	
							$uniprot_evalue = mysql_result($result,$i,"uniprot_evalue");  
							$events_string = mysql_result($result,$i,"events_string");  
							$events_string = str_replace('miRNA', 'miRNA-associated', $events_string);
							$events_string = str_replace('splicing', 'splicing regulation', $events_string);
							$chr = mysql_result($result,$i,"chr");  
							$this_start = mysql_result($result,$i,"start");  
							$this_end = mysql_result($result,$i,"end");  
							$strand = mysql_result($result,$i,"strand");  
							$max_expression = mysql_result($result,$i,"max_expression");  
	
							$species_full = $species_list_full[$species];
							$species_full = str_replace(' ', '_', $species_full);
							$ensembl_link = "http://plants.ensembl.org/" . $species_full . "/Location/View?db=core;r=" . $chr . ':' . $this_start . '-' . $this_end;
	
	
	
	
							$this_species = $species_list[$this_species];
	
							$display_id = generate_id($id);
	
							$species_full_space = str_replace('_', ' ', $species_full);

							print "
								<tr>
									<td>$display_id</td>
									<td nowrap><i>$this_species</i></td>
									<td nowrap><a href = $ensembl_link title = 'View the region at Ensembl Plants'>$chr:$this_start-$this_end ($strand)</a></td>
									<td>$cpc_status ($cpc_score)</td>";
									if($uniprot_evalue > -1)
										{
										print "<td>$uniprot_evalue (<a href = $uniprot_link>$uniprot_hit</a>)</td>";
										}
									else
										{
										print "<td>-</td>";                
										}
									print "
									<td>$max_peptide_length</td>
									<td>$max_expression</td>
									<td>$events_string</td>
									<td><a href = details.php?id=$id&species=$species>Details</a></td>
								</tr>";
							}

			
						print "</tbody></table></div>";   
						}


					function generate_id($id)
						{
						$length = strlen($id);
						for($i = 0; $i < (7-$length); $i++)
							{
							$id = '0' . $id;
							}
						$id = 'CNT' . $id;
						return $id;
						}

					function raw_id($id)
						{
						$id = str_replace('CNT', '', $id);
						$id = intval($id);
						return $id;
						}    
	
					if($number < 10)
						{
						print "<br /><br /><br /><br /><br /><br /><br /><br /><br />";
						}
 
            	
            	
            	?>
            
            
            
                
            </div>
        </div>
    
    
    <br><br><br><br><br><br><br><br><br><br>
    
    	<br><br><hr>
    	<footer>
			<div class="row">
				<div class="col-lg-12">
				<p style="color: grey; text-align:center;">Copyright &copy; CANTATAdb 2015</p>
				</div>
			</div>
    	</footer>
    </div>
    
    <div class="container">
		<section>
			<table id="example" class="display" cellspacing="0" width="100%">
				<thead>
					<tr>
						<th>First name</th>
						<th>Last name</th>
						<th>Position</th>
						<th>Office</th>
						<th>Age</th>
						<th>Start date</th>
						<th>Salary</th>
						<th>Extn.</th>
						<th>E-mail</th>
					</tr>
				</thead>

				<tbody>
					<tr>
						<td>Tiger</td>
						<td>Nixon</td>
						<td>System Architect</td>
						<td>Edinburgh</td>
						<td>61</td>
						<td>2011/04/25</td>
						<td>$320,800</td>
						<td>5421</td>
						<td>t.nixon@datatables.net</td>
					</tr>
					<tr>
						<td>Garrett</td>
						<td>Winters</td>
						<td>Accountant</td>
						<td>Tokyo</td>
						<td>63</td>
						<td>2011/07/25</td>
						<td>$170,750</td>
						<td>8422</td>
						<td>g.winters@datatables.net</td>
					</tr>
					<tr>
						<td>Ashton</td>
						<td>Cox</td>
						<td>Junior Technical Author</td>
						<td>San Francisco</td>
						<td>66</td>
						<td>2009/01/12</td>
						<td>$86,000</td>
						<td>1562</td>
						<td>a.cox@datatables.net</td>
					</tr>
					<tr>
						<td>Cedric</td>
						<td>Kelly</td>
						<td>Senior Javascript Developer</td>
						<td>Edinburgh</td>
						<td>22</td>
						<td>2012/03/29</td>
						<td>$433,060</td>
						<td>6224</td>
						<td>c.kelly@datatables.net</td>
					</tr>
					<tr>
						<td>Airi</td>
						<td>Satou</td>
						<td>Accountant</td>
						<td>Tokyo</td>
						<td>33</td>
						<td>2008/11/28</td>
						<td>$162,700</td>
						<td>5407</td>
						<td>a.satou@datatables.net</td>
					</tr>
					<tr>
						<td>Brielle</td>
						<td>Williamson</td>
						<td>Integration Specialist</td>
						<td>New York</td>
						<td>61</td>
						<td>2012/12/02</td>
						<td>$372,000</td>
						<td>4804</td>
						<td>b.williamson@datatables.net</td>
					</tr>
					<tr>
						<td>Herrod</td>
						<td>Chandler</td>
						<td>Sales Assistant</td>
						<td>San Francisco</td>
						<td>59</td>
						<td>2012/08/06</td>
						<td>$137,500</td>
						<td>9608</td>
						<td>h.chandler@datatables.net</td>
					</tr>
					<tr>
						<td>Rhona</td>
						<td>Davidson</td>
						<td>Integration Specialist</td>
						<td>Tokyo</td>
						<td>55</td>
						<td>2010/10/14</td>
						<td>$327,900</td>
						<td>6200</td>
						<td>r.davidson@datatables.net</td>
					</tr>
					<tr>
						<td>Colleen</td>
						<td>Hurst</td>
						<td>Javascript Developer</td>
						<td>San Francisco</td>
						<td>39</td>
						<td>2009/09/15</td>
						<td>$205,500</td>
						<td>2360</td>
						<td>c.hurst@datatables.net</td>
					</tr>
					<tr>
						<td>Sonya</td>
						<td>Frost</td>
						<td>Software Engineer</td>
						<td>Edinburgh</td>
						<td>23</td>
						<td>2008/12/13</td>
						<td>$103,600</td>
						<td>1667</td>
						<td>s.frost@datatables.net</td>
					</tr>
					<tr>
						<td>Jena</td>
						<td>Gaines</td>
						<td>Office Manager</td>
						<td>London</td>
						<td>30</td>
						<td>2008/12/19</td>
						<td>$90,560</td>
						<td>3814</td>
						<td>j.gaines@datatables.net</td>
					</tr>
					<tr>
						<td>Quinn</td>
						<td>Flynn</td>
						<td>Support Lead</td>
						<td>Edinburgh</td>
						<td>22</td>
						<td>2013/03/03</td>
						<td>$342,000</td>
						<td>9497</td>
						<td>q.flynn@datatables.net</td>
					</tr>
					<tr>
						<td>Charde</td>
						<td>Marshall</td>
						<td>Regional Director</td>
						<td>San Francisco</td>
						<td>36</td>
						<td>2008/10/16</td>
						<td>$470,600</td>
						<td>6741</td>
						<td>c.marshall@datatables.net</td>
					</tr>
					<tr>
						<td>Haley</td>
						<td>Kennedy</td>
						<td>Senior Marketing Designer</td>
						<td>London</td>
						<td>43</td>
						<td>2012/12/18</td>
						<td>$313,500</td>
						<td>3597</td>
						<td>h.kennedy@datatables.net</td>
					</tr>
					<tr>
						<td>Tatyana</td>
						<td>Fitzpatrick</td>
						<td>Regional Director</td>
						<td>London</td>
						<td>19</td>
						<td>2010/03/17</td>
						<td>$385,750</td>
						<td>1965</td>
						<td>t.fitzpatrick@datatables.net</td>
					</tr>
					<tr>
						<td>Michael</td>
						<td>Silva</td>
						<td>Marketing Designer</td>
						<td>London</td>
						<td>66</td>
						<td>2012/11/27</td>
						<td>$198,500</td>
						<td>1581</td>
						<td>m.silva@datatables.net</td>
					</tr>
					<tr>
						<td>Paul</td>
						<td>Byrd</td>
						<td>Chief Financial Officer (CFO)</td>
						<td>New York</td>
						<td>64</td>
						<td>2010/06/09</td>
						<td>$725,000</td>
						<td>3059</td>
						<td>p.byrd@datatables.net</td>
					</tr>
					<tr>
						<td>Gloria</td>
						<td>Little</td>
						<td>Systems Administrator</td>
						<td>New York</td>
						<td>59</td>
						<td>2009/04/10</td>
						<td>$237,500</td>
						<td>1721</td>
						<td>g.little@datatables.net</td>
					</tr>
					<tr>
						<td>Bradley</td>
						<td>Greer</td>
						<td>Software Engineer</td>
						<td>London</td>
						<td>41</td>
						<td>2012/10/13</td>
						<td>$132,000</td>
						<td>2558</td>
						<td>b.greer@datatables.net</td>
					</tr>
					<tr>
						<td>Dai</td>
						<td>Rios</td>
						<td>Personnel Lead</td>
						<td>Edinburgh</td>
						<td>35</td>
						<td>2012/09/26</td>
						<td>$217,500</td>
						<td>2290</td>
						<td>d.rios@datatables.net</td>
					</tr>
					<tr>
						<td>Jenette</td>
						<td>Caldwell</td>
						<td>Development Lead</td>
						<td>New York</td>
						<td>30</td>
						<td>2011/09/03</td>
						<td>$345,000</td>
						<td>1937</td>
						<td>j.caldwell@datatables.net</td>
					</tr>
					<tr>
						<td>Yuri</td>
						<td>Berry</td>
						<td>Chief Marketing Officer (CMO)</td>
						<td>New York</td>
						<td>40</td>
						<td>2009/06/25</td>
						<td>$675,000</td>
						<td>6154</td>
						<td>y.berry@datatables.net</td>
					</tr>
					<tr>
						<td>Caesar</td>
						<td>Vance</td>
						<td>Pre-Sales Support</td>
						<td>New York</td>
						<td>21</td>
						<td>2011/12/12</td>
						<td>$106,450</td>
						<td>8330</td>
						<td>c.vance@datatables.net</td>
					</tr>
					<tr>
						<td>Doris</td>
						<td>Wilder</td>
						<td>Sales Assistant</td>
						<td>Sidney</td>
						<td>23</td>
						<td>2010/09/20</td>
						<td>$85,600</td>
						<td>3023</td>
						<td>d.wilder@datatables.net</td>
					</tr>
					<tr>
						<td>Angelica</td>
						<td>Ramos</td>
						<td>Chief Executive Officer (CEO)</td>
						<td>London</td>
						<td>47</td>
						<td>2009/10/09</td>
						<td>$1,200,000</td>
						<td>5797</td>
						<td>a.ramos@datatables.net</td>
					</tr>
					<tr>
						<td>Gavin</td>
						<td>Joyce</td>
						<td>Developer</td>
						<td>Edinburgh</td>
						<td>42</td>
						<td>2010/12/22</td>
						<td>$92,575</td>
						<td>8822</td>
						<td>g.joyce@datatables.net</td>
					</tr>
					<tr>
						<td>Jennifer</td>
						<td>Chang</td>
						<td>Regional Director</td>
						<td>Singapore</td>
						<td>28</td>
						<td>2010/11/14</td>
						<td>$357,650</td>
						<td>9239</td>
						<td>j.chang@datatables.net</td>
					</tr>
					<tr>
						<td>Brenden</td>
						<td>Wagner</td>
						<td>Software Engineer</td>
						<td>San Francisco</td>
						<td>28</td>
						<td>2011/06/07</td>
						<td>$206,850</td>
						<td>1314</td>
						<td>b.wagner@datatables.net</td>
					</tr>
					<tr>
						<td>Fiona</td>
						<td>Green</td>
						<td>Chief Operating Officer (COO)</td>
						<td>San Francisco</td>
						<td>48</td>
						<td>2010/03/11</td>
						<td>$850,000</td>
						<td>2947</td>
						<td>f.green@datatables.net</td>
					</tr>
					<tr>
						<td>Shou</td>
						<td>Itou</td>
						<td>Regional Marketing</td>
						<td>Tokyo</td>
						<td>20</td>
						<td>2011/08/14</td>
						<td>$163,000</td>
						<td>8899</td>
						<td>s.itou@datatables.net</td>
					</tr>
					<tr>
						<td>Michelle</td>
						<td>House</td>
						<td>Integration Specialist</td>
						<td>Sidney</td>
						<td>37</td>
						<td>2011/06/02</td>
						<td>$95,400</td>
						<td>2769</td>
						<td>m.house@datatables.net</td>
					</tr>
					<tr>
						<td>Suki</td>
						<td>Burks</td>
						<td>Developer</td>
						<td>London</td>
						<td>53</td>
						<td>2009/10/22</td>
						<td>$114,500</td>
						<td>6832</td>
						<td>s.burks@datatables.net</td>
					</tr>
					<tr>
						<td>Prescott</td>
						<td>Bartlett</td>
						<td>Technical Author</td>
						<td>London</td>
						<td>27</td>
						<td>2011/05/07</td>
						<td>$145,000</td>
						<td>3606</td>
						<td>p.bartlett@datatables.net</td>
					</tr>
					<tr>
						<td>Gavin</td>
						<td>Cortez</td>
						<td>Team Leader</td>
						<td>San Francisco</td>
						<td>22</td>
						<td>2008/10/26</td>
						<td>$235,500</td>
						<td>2860</td>
						<td>g.cortez@datatables.net</td>
					</tr>
					<tr>
						<td>Martena</td>
						<td>Mccray</td>
						<td>Post-Sales support</td>
						<td>Edinburgh</td>
						<td>46</td>
						<td>2011/03/09</td>
						<td>$324,050</td>
						<td>8240</td>
						<td>m.mccray@datatables.net</td>
					</tr>
					<tr>
						<td>Unity</td>
						<td>Butler</td>
						<td>Marketing Designer</td>
						<td>San Francisco</td>
						<td>47</td>
						<td>2009/12/09</td>
						<td>$85,675</td>
						<td>5384</td>
						<td>u.butler@datatables.net</td>
					</tr>
					<tr>
						<td>Howard</td>
						<td>Hatfield</td>
						<td>Office Manager</td>
						<td>San Francisco</td>
						<td>51</td>
						<td>2008/12/16</td>
						<td>$164,500</td>
						<td>7031</td>
						<td>h.hatfield@datatables.net</td>
					</tr>
					<tr>
						<td>Hope</td>
						<td>Fuentes</td>
						<td>Secretary</td>
						<td>San Francisco</td>
						<td>41</td>
						<td>2010/02/12</td>
						<td>$109,850</td>
						<td>6318</td>
						<td>h.fuentes@datatables.net</td>
					</tr>
					<tr>
						<td>Vivian</td>
						<td>Harrell</td>
						<td>Financial Controller</td>
						<td>San Francisco</td>
						<td>62</td>
						<td>2009/02/14</td>
						<td>$452,500</td>
						<td>9422</td>
						<td>v.harrell@datatables.net</td>
					</tr>
					<tr>
						<td>Timothy</td>
						<td>Mooney</td>
						<td>Office Manager</td>
						<td>London</td>
						<td>37</td>
						<td>2008/12/11</td>
						<td>$136,200</td>
						<td>7580</td>
						<td>t.mooney@datatables.net</td>
					</tr>
					<tr>
						<td>Jackson</td>
						<td>Bradshaw</td>
						<td>Director</td>
						<td>New York</td>
						<td>65</td>
						<td>2008/09/26</td>
						<td>$645,750</td>
						<td>1042</td>
						<td>j.bradshaw@datatables.net</td>
					</tr>
					<tr>
						<td>Olivia</td>
						<td>Liang</td>
						<td>Support Engineer</td>
						<td>Singapore</td>
						<td>64</td>
						<td>2011/02/03</td>
						<td>$234,500</td>
						<td>2120</td>
						<td>o.liang@datatables.net</td>
					</tr>
					<tr>
						<td>Bruno</td>
						<td>Nash</td>
						<td>Software Engineer</td>
						<td>London</td>
						<td>38</td>
						<td>2011/05/03</td>
						<td>$163,500</td>
						<td>6222</td>
						<td>b.nash@datatables.net</td>
					</tr>
					<tr>
						<td>Sakura</td>
						<td>Yamamoto</td>
						<td>Support Engineer</td>
						<td>Tokyo</td>
						<td>37</td>
						<td>2009/08/19</td>
						<td>$139,575</td>
						<td>9383</td>
						<td>s.yamamoto@datatables.net</td>
					</tr>
					<tr>
						<td>Thor</td>
						<td>Walton</td>
						<td>Developer</td>
						<td>New York</td>
						<td>61</td>
						<td>2013/08/11</td>
						<td>$98,540</td>
						<td>8327</td>
						<td>t.walton@datatables.net</td>
					</tr>
					<tr>
						<td>Finn</td>
						<td>Camacho</td>
						<td>Support Engineer</td>
						<td>San Francisco</td>
						<td>47</td>
						<td>2009/07/07</td>
						<td>$87,500</td>
						<td>2927</td>
						<td>f.camacho@datatables.net</td>
					</tr>
					<tr>
						<td>Serge</td>
						<td>Baldwin</td>
						<td>Data Coordinator</td>
						<td>Singapore</td>
						<td>64</td>
						<td>2012/04/09</td>
						<td>$138,575</td>
						<td>8352</td>
						<td>s.baldwin@datatables.net</td>
					</tr>
					<tr>
						<td>Zenaida</td>
						<td>Frank</td>
						<td>Software Engineer</td>
						<td>New York</td>
						<td>63</td>
						<td>2010/01/04</td>
						<td>$125,250</td>
						<td>7439</td>
						<td>z.frank@datatables.net</td>
					</tr>
					<tr>
						<td>Zorita</td>
						<td>Serrano</td>
						<td>Software Engineer</td>
						<td>San Francisco</td>
						<td>56</td>
						<td>2012/06/01</td>
						<td>$115,000</td>
						<td>4389</td>
						<td>z.serrano@datatables.net</td>
					</tr>
					<tr>
						<td>Jennifer</td>
						<td>Acosta</td>
						<td>Junior Javascript Developer</td>
						<td>Edinburgh</td>
						<td>43</td>
						<td>2013/02/01</td>
						<td>$75,650</td>
						<td>3431</td>
						<td>j.acosta@datatables.net</td>
					</tr>
					<tr>
						<td>Cara</td>
						<td>Stevens</td>
						<td>Sales Assistant</td>
						<td>New York</td>
						<td>46</td>
						<td>2011/12/06</td>
						<td>$145,600</td>
						<td>3990</td>
						<td>c.stevens@datatables.net</td>
					</tr>
					<tr>
						<td>Hermione</td>
						<td>Butler</td>
						<td>Regional Director</td>
						<td>London</td>
						<td>47</td>
						<td>2011/03/21</td>
						<td>$356,250</td>
						<td>1016</td>
						<td>h.butler@datatables.net</td>
					</tr>
					<tr>
						<td>Lael</td>
						<td>Greer</td>
						<td>Systems Administrator</td>
						<td>London</td>
						<td>21</td>
						<td>2009/02/27</td>
						<td>$103,500</td>
						<td>6733</td>
						<td>l.greer@datatables.net</td>
					</tr>
					<tr>
						<td>Jonas</td>
						<td>Alexander</td>
						<td>Developer</td>
						<td>San Francisco</td>
						<td>30</td>
						<td>2010/07/14</td>
						<td>$86,500</td>
						<td>8196</td>
						<td>j.alexander@datatables.net</td>
					</tr>
					<tr>
						<td>Shad</td>
						<td>Decker</td>
						<td>Regional Director</td>
						<td>Edinburgh</td>
						<td>51</td>
						<td>2008/11/13</td>
						<td>$183,000</td>
						<td>6373</td>
						<td>s.decker@datatables.net</td>
					</tr>
					<tr>
						<td>Michael</td>
						<td>Bruce</td>
						<td>Javascript Developer</td>
						<td>Singapore</td>
						<td>29</td>
						<td>2011/06/27</td>
						<td>$183,000</td>
						<td>5384</td>
						<td>m.bruce@datatables.net</td>
					</tr>
					<tr>
						<td>Donna</td>
						<td>Snider</td>
						<td>Customer Support</td>
						<td>New York</td>
						<td>27</td>
						<td>2011/01/25</td>
						<td>$112,000</td>
						<td>4226</td>
						<td>d.snider@datatables.net</td>
					</tr>
				</tbody>
			</table>
		</section>
	</div>
    
    
    <!-- /.container -->
	
	
    <!-- jQuery -->
    <!-- <script src="js/jquery.js"></script> -->

    <!-- Bootstrap Core JavaScript -->
    <!-- <script src="js/bootstrap.min.js"></script> -->

</body>

</html>
